/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.listener;

import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.util.ApplicationContextUtils;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Conditional(value={AlibabaCondition.class})
@Component
public class AlibabaMqListenerUtil {
    private static final Logger log = LoggerFactory.getLogger(AlibabaMqListenerUtil.class);

    public Object handleMessage(Map<String, Map<String, Set<String>>> topicBeanMap, MqMessageVo message) {
        Assert.notEmpty(topicBeanMap, (String)"\u6d88\u8d39\u8005\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a!");
        Map<String, Set<String>> tagMap = topicBeanMap.get(message.getTopic());
        Assert.notEmpty(tagMap, (String)("topic[" + message.getTopic() + "]\u672a\u627e\u5230tag!"));
        Set<String> serviceNameSet = tagMap.get(message.getTag());
        Assert.notEmpty(serviceNameSet, (String)("topic[" + message.getTopic() + "]tag[" + message.getTag() + "]\u672a\u627e\u5230\u6d88\u8d39\u8005"));
        serviceNameSet.forEach(serviceName -> {
            try {
                Object bean = ApplicationContextUtils.getContext().getBean(serviceName);
                Class<?> forName = bean.getClass();
                Method method = forName.getDeclaredMethod("handleMessage", MqMessageVo.class);
                method.setAccessible(true);
                method.invoke(bean, message);
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("\u6d88\u8d39\u5931\u8d25,\u83b7\u53d6\u6267\u884c\u7c7b\u5931\u8d25!");
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("\u6d88\u8d39\u5931\u8d25,\u6267\u884c\u65b9\u6cd5!");
            }
            catch (InvocationTargetException e) {
                log.error("\u6620\u5c04\u7684\u65b9\u6cd5\u6267\u884c\u5f02\u5e38=====>");
                log.error("[{}]", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        });
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

