/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.task;

import com.biz.crm.business.common.base.service.RedisLockService;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.service.MqCleanLogExtendService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class DeleteMqLogCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DeleteMqLogCornTask.class);
    private static final String DEFAULT_CRON = "0 0 5 * * ?";
    private String cron = "0 0 5 * * ?";
    @Resource
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Resource
    private RocketMqConfig rocketMqConfig;
    @Autowired(required=false)
    private MqCleanLogExtendService mqCleanLogExtendService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @PostConstruct
    private void setDeleteMqLogCron() {
        this.setCron(this.rocketMqConfig.getCleanCron());
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::deleteData, triggerContext -> {
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     \u6e05\u7406MQ\u53d1\u9001\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1:\u539f\u6765\u7684cron\uff1a[{}]]\u66f4\u65b0\u540e\u7684cron\uff1a[{}]     <=====", (Object)this.cron, (Object)cron);
        this.cron = cron;
    }

    public String getCron() {
        return this.cron;
    }

    private void deleteData() {
        String lockKey;
        block9: {
            boolean lock;
            lockKey = "mq:del_log";
            if (this.redisLockService != null && !(lock = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L))) {
                return;
            }
            if (this.mqCleanLogExtendService == null) {
                try {
                    long totalCount;
                    Long minNum;
                    Integer saveDay = this.rocketMqConfig.getSaveDay();
                    if (saveDay == null) {
                        saveDay = 14;
                    }
                    if ((minNum = this.rocketMqConfig.getMinNum()) == null) {
                        minNum = 10000L;
                    }
                    if ((totalCount = this.elasticsearchRestTemplate.count((Query)new NativeSearchQuery((QueryBuilder)QueryBuilders.boolQuery()), RocketMqMessageLogDocument.class)) > minNum) {
                        long saveDayMillis = 86400000L * (long)saveDay.intValue();
                        long cleanMillis = System.currentTimeMillis() - saveDayMillis;
                        log.info("MQ\u65e5\u5fd7\u6e05\u7406[{}]\u53ca\u5176\u4ee5\u524d\u7684", (Object)RocketMqUtil.DATETIME_FORMAT.format(new Date(cleanMillis)));
                        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createDateSort").lte((Object)cleanMillis));
                        NativeSearchQuery deleteQuery = new NativeSearchQuery((QueryBuilder)boolQueryBuilder);
                        ByQueryResponse queryResponse = this.elasticsearchRestTemplate.delete((Query)deleteQuery, RocketMqMessageLogDocument.class);
                        log.info("MQ\u65e5\u5fd7\u6e05\u7406\u6570\u91cf:[{}]\u6761", (Object)queryResponse.getDeleted());
                        break block9;
                    }
                    log.info("MQ\u65e5\u5fd7\u5f53\u524d\u603b[{}]\u6761,\u5c0f\u4e8e\u65e5\u5fd7\u4fdd\u6709\u6700\u5c0f\u91cf[{}],\u4e0d\u6e05\u7406\u65e5\u5fd7\u3002", (Object)totalCount, (Object)minNum);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                this.mqCleanLogExtendService.cleanMqLog();
            }
        }
        if (this.redisLockService != null) {
            this.redisLockService.unlock(lockKey);
        }
    }
}

