/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.util;

import com.biz.crm.business.common.rocketmq.util.ApplicationContextUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class AlibabaMqTopicAndTagUtil {
    private static final Logger log = LoggerFactory.getLogger(AlibabaMqTopicAndTagUtil.class);
    private static boolean hasBuild = false;
    private static final Map<String, Map<String, Set<String>>> TOPIC_MAP = new HashMap<String, Map<String, Set<String>>>(4);
    private static final Map<String, Map<String, Set<String>>> TOPIC_ORDER_MAP = new HashMap<String, Map<String, Set<String>>>(4);

    private static void builderMap() {
        String[] serviceNames;
        ApplicationContext applicationContext = ApplicationContextUtils.getContext();
        Environment env = applicationContext.getEnvironment();
        String keyCharacter = "\\|\\|";
        for (String serviceName : serviceNames = applicationContext.getBeanNamesForAnnotation(RocketMQMessageListener.class)) {
            Object bean = applicationContext.getBean(serviceName);
            Class<?> forName = bean.getClass();
            RocketMQMessageListener mqMessageListener = forName.getAnnotation(RocketMQMessageListener.class);
            Assert.hasText((String)mqMessageListener.topic(), (String)"topic\u4e0d\u80fd\u4e3a\u7a7a!");
            StringBuilder topicBuilder = new StringBuilder();
            for (String s : mqMessageListener.topic().split("\\$")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                if (s.contains("{")) {
                    s = s.replaceAll("\\{", "");
                    s = s.replaceAll("\\}", "");
                    topicBuilder.append(StringUtils.stripToEmpty((String)env.getProperty(s)));
                    continue;
                }
                topicBuilder.append(s);
            }
            String topic = topicBuilder.toString();
            Assert.hasText((String)topic, (String)"topic\u4e0d\u80fd\u4e3a\u7a7a!");
            for (String tag : mqMessageListener.selectorExpression().split(keyCharacter)) {
                MessageModel messageModel = mqMessageListener.messageModel();
                if (ConsumeMode.ORDERLY.equals((Object)mqMessageListener.consumeMode())) {
                    if (MessageModel.CLUSTERING.equals((Object)messageModel)) {
                        AlibabaMqTopicAndTagUtil.buildMap(topic, tag, serviceName, TOPIC_ORDER_MAP);
                        continue;
                    }
                    if (MessageModel.BROADCASTING.equals((Object)messageModel)) {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u5e7f\u64ad,\u8bf7\u7528\u6d88\u8d39\u7ec4\u6982\u5ff5\u5b9e\u73b0!");
                    }
                    throw new RuntimeException("MQ\u76d1\u542cMessageModel\u9519\u8bef");
                }
                if (ConsumeMode.CONCURRENTLY.equals((Object)mqMessageListener.consumeMode())) {
                    if (MessageModel.CLUSTERING.equals((Object)messageModel)) {
                        AlibabaMqTopicAndTagUtil.buildMap(topic, tag, serviceName, TOPIC_MAP);
                        continue;
                    }
                    if (MessageModel.BROADCASTING.equals((Object)messageModel)) {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u5e7f\u64ad,\u8bf7\u7528\u6d88\u8d39\u7ec4\u6982\u5ff5\u5b9e\u73b0!");
                    }
                    throw new RuntimeException("MQ\u76d1\u542cMessageModel\u9519\u8bef");
                }
                throw new RuntimeException("MQ\u76d1\u542cConsumeMode\u9519\u8bef");
            }
        }
        log.info("=====>    \u963f\u91ccMQ\u6d88\u8d39\u6709\u5e8f\u76d1\u542c[{}]    <=====", TOPIC_ORDER_MAP);
        log.info("=====>    \u963f\u91ccMQ\u6d88\u8d39\u96c6\u7fa4\u76d1\u542c[{}]    <=====", TOPIC_MAP);
        hasBuild = true;
    }

    private static void buildMap(String topic, String tag, String serviceName, Map<String, Map<String, Set<String>>> topicMap) {
        if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)tag) || StringUtils.isEmpty((CharSequence)serviceName)) {
            return;
        }
        Map<String, Set<String>> tagMap = topicMap.getOrDefault(topic, Maps.newHashMap());
        Set<String> serviceSet = tagMap.getOrDefault(tag, Sets.newHashSet());
        serviceSet.add(serviceName);
        tagMap.put(tag, serviceSet);
        topicMap.put(topic, tagMap);
    }

    public static Map<String, Map<String, Set<String>>> getTopicMap() {
        if (!hasBuild) {
            AlibabaMqTopicAndTagUtil.builderMap();
        }
        return TOPIC_MAP;
    }

    public static Map<String, Map<String, Set<String>>> getTopicOrderMap() {
        if (!hasBuild) {
            AlibabaMqTopicAndTagUtil.builderMap();
        }
        return TOPIC_ORDER_MAP;
    }
}

