/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import com.biz.crm.business.common.rocketmq.service.MqEventDemoService;
import com.biz.crm.business.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rocketmq/rocketMqSend"})
@Api(tags={"RocketMq\u6d88\u606f\u961f\u5217: rocketMq"})
public class RocketMqSendDemoController {
    private static final Logger log = LoggerFactory.getLogger(RocketMqSendDemoController.class);
    @Resource
    private RocketMqProducer rocketMqProducer;
    @Resource
    private MqEventDemoService mqEventDemoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u6d4b\u8bd5rocketMq\u53d1\u9001\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tipMsg", value="\u6d88\u606f\u5185\u5bb9", dataTypeClass=String.class, paramType="query", defaultValue="hello,\u666e\u901a\u7c7b\u578bMQ\u6d88\u606f\u6d4b\u8bd5\u3002"), @ApiImplicitParam(name="order", value="\u662f\u5426\u987a\u5e8f", dataTypeClass=Boolean.class, defaultValue="false", paramType="query"), @ApiImplicitParam(name="time", value="\u53d1\u9001\u6b21\u6570", dataTypeClass=String.class, defaultValue="9", paramType="query"), @ApiImplicitParam(name="deliverSecond", value="\u5ef6\u8fdf\u65f6\u95f4/\u79d2", dataTypeClass=Long.class, defaultValue="0", paramType="query"), @ApiImplicitParam(name="repeatConsumer", value="\u662f\u5426\u53ef\u91cd\u590d\u6d88\u8d39", dataTypeClass=Boolean.class, defaultValue="false", paramType="query")})
    @GetMapping(value={"sendMqMsg"})
    public Result sendMqMsg(@RequestParam(value="tipMsg") String msg, @RequestParam(value="order") Boolean order, @RequestParam(value="time") Integer time, @RequestParam(value="deliverSecond") long deliverSecond, @RequestParam(value="repeatConsumer") boolean repeatConsumer) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (this.loginUserService != null) {
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity);
            currentAccount = this.loginUserService.getLoginAccountName();
        }
        for (int i = 0; i < time; ++i) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setCurrentAccount(currentAccount);
            mqMessageVo.setAccountJson(accountJson);
            mqMessageVo.setRepeatConsumer(repeatConsumer);
            mqMessageVo.setTag("TAG_TEST");
            mqMessageVo.setMsgBody("\u6d88\u606f[" + i + "]" + msg);
            mqMessageVo.setMsgNum(1);
            if (Objects.nonNull(order) && order.booleanValue()) {
                this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, uuid, deliverSecond);
                continue;
            }
            this.rocketMqProducer.sendMqMsg(mqMessageVo, deliverSecond);
        }
        return Result.ok();
    }

    @ApiOperation(value="\u6d4b\u8bd5rocketMq\u6d88\u606f(\u4e8b\u52a1\u5b8c\u6210\u540e)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tipMsg", value="\u6d88\u606f\u5185\u5bb9", dataTypeClass=String.class, paramType="query", defaultValue="hello,\u4e8b\u4ef6\u7c7b\u578bMQ\u6d88\u606f\u6d4b\u8bd5\u3002"), @ApiImplicitParam(name="order", value="\u662f\u5426\u987a\u5e8f", dataTypeClass=Boolean.class, defaultValue="false", paramType="query"), @ApiImplicitParam(name="time", value="\u7f16\u7801\u7f16\u7801", dataTypeClass=String.class, defaultValue="9", paramType="query"), @ApiImplicitParam(name="deliverSecond", value="\u5ef6\u8fdf\u65f6\u95f4/\u79d2", dataTypeClass=Long.class, defaultValue="0", paramType="query"), @ApiImplicitParam(name="repeatConsumer", value="\u662f\u5426\u53ef\u91cd\u590d\u6d88\u8d39", dataTypeClass=Boolean.class, defaultValue="false", paramType="query")})
    @GetMapping(value={"sendMqEventMsg"})
    public Result sendMqEventMsg(@RequestParam(value="tipMsg") String msg, @RequestParam(value="order") Boolean order, @RequestParam(value="time") Integer time, @RequestParam(value="deliverSecond") long deliverSecond, @RequestParam(value="repeatConsumer") boolean repeatConsumer) {
        Assert.notNull((Object)time, (String)"\u53d1\u9001\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time > 0 ? 1 : 0) != 0, (String)"\u53d1\u9001\u6b21\u6570\u4e0d\u80fd\u5c0f\u4e8e1!");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < time; ++i) {
            list.add("\u6d88\u606f[" + i + "]" + msg);
        }
        this.mqEventDemoService.sendMqEventDemo(order, list, deliverSecond, repeatConsumer);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524dMQ\u7c7b\u578b")
    @GetMapping(value={"getCurrentMqType"})
    public Result getCurrentMqType() {
        JSONObject jsonObject = new JSONObject();
        RocketMqTypeEnum typeEnum = this.rocketMqProducer.getCurrentMqType();
        jsonObject.put("code", (Object)typeEnum.getCode());
        jsonObject.put("desc", (Object)typeEnum.getDesc());
        return Result.ok((Object)jsonObject);
    }
}

