/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.service;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import com.biz.crm.business.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.business.common.rocketmq.repository.RocketMqMessageLogDocumentRepository;
import com.biz.crm.business.common.rocketmq.service.BuildMqInfoExtendService;
import com.biz.crm.business.common.rocketmq.service.MqCommonService;
import com.biz.crm.business.common.rocketmq.service.MqExceptionExtendService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class RocketMqProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMqProducer.class);
    @Resource
    private MqCommonService mqCommonService;
    @Autowired(required=false)
    private RocketMqMessageLogDocumentRepository rocketMqMessageLogDocumentRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private MqExceptionExtendService mqExceptionExtendService;
    @Autowired(required=false)
    private BuildMqInfoExtendService buildMqInfoExtendService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    protected final Integer DEF_SIZE = 200;

    public RocketMqTypeEnum getCurrentMqType() {
        return this.mqCommonService.getMqTypeEnum();
    }

    public void sendMqMsg(MqMessageVo mqMessageVo) {
        this.sendMqMsg(mqMessageVo, 0L);
    }

    public void sendMqMsg(MqMessageVo mqMessageVo, long deliverSecond) {
        if (!StringUtils.hasText((String)mqMessageVo.getTopic())) {
            mqMessageVo.setTopic(RocketMqUtil.getTopic());
        }
        if (!mqMessageVo.getTopic().contains(RocketMqUtil.mqEnvironment())) {
            mqMessageVo.setTopic(mqMessageVo.getTopic() + RocketMqUtil.mqEnvironment());
        }
        RocketMqMessageLogDocument logVo = this.buildMqLog(mqMessageVo);
        log.info("\u53d1\u9001\u7684MQ\u6d88\u606f\u5185\u5bb9[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
        try {
            this.mqCommonService.sendMqMsg(logVo, mqMessageVo, deliverSecond);
        }
        catch (IllegalArgumentException e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
            log.error(e.getMessage(), (Throwable)e);
            this.sendMqExceptionSaveLog(logVo, mqMessageVo, e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
            log.error(e.getMessage(), (Throwable)e);
            this.sendMqExceptionSaveLog(logVo, mqMessageVo, e);
            throw new IllegalArgumentException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u6d88\u606fID[" + logVo.getId() + "]");
        }
    }

    public void sendMqOrderMsg(MqMessageVo mqMessageVo) {
        Assert.hasText((String)mqMessageVo.getTag(), (String)"MQ\u7684tag\u4e0d\u80fd\u4e3a\u7a7a!");
        this.sendMqOrderMsg(mqMessageVo, mqMessageVo.getTag(), 0L);
    }

    public void sendMqOrderMsg(MqMessageVo mqMessageVo, long deliverSecond) {
        Assert.hasText((String)mqMessageVo.getTag(), (String)"MQ\u7684tag\u4e0d\u80fd\u4e3a\u7a7a!");
        this.sendMqOrderMsg(mqMessageVo, mqMessageVo.getTag(), deliverSecond);
    }

    public void sendMqOrderMsg(MqMessageVo mqMessageVo, String shardingKey) {
        this.sendMqOrderMsg(mqMessageVo, shardingKey, 0L);
    }

    public void sendMqOrderMsg(MqMessageVo mqMessageVo, String shardingKey, long deliverSecond) {
        if (!StringUtils.hasText((String)mqMessageVo.getTopic())) {
            mqMessageVo.setTopic(RocketMqUtil.getOrderTopic());
        }
        Assert.hasText((String)shardingKey, (String)"MQ\u987a\u5e8f\u6d88\u606f,\u552f\u4e00\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a!(\u5f53\u65e0\u6cd5\u786e\u8ba4\u552f\u4e00\u6807\u8bb0\u65f6,\u53ef\u4f20tag)");
        if (!mqMessageVo.getTopic().contains(RocketMqUtil.mqEnvironment())) {
            mqMessageVo.setTopic(mqMessageVo.getTopic() + RocketMqUtil.mqEnvironment());
        }
        RocketMqMessageLogDocument logVo = this.buildMqLog(mqMessageVo);
        log.info("\u53d1\u9001\u7684MQ\u6d88\u606f\u5185\u5bb9[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
        try {
            this.mqCommonService.sendMqOrderMsg(logVo, mqMessageVo, shardingKey, deliverSecond);
        }
        catch (IllegalArgumentException e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
            log.error(e.getMessage(), (Throwable)e);
            this.sendMqExceptionSaveLog(logVo, mqMessageVo, e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25[{}]", (Object)JSON.toJSONString((Object)mqMessageVo));
            log.error(e.getMessage(), (Throwable)e);
            this.sendMqExceptionSaveLog(logVo, mqMessageVo, e);
            throw new IllegalArgumentException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u6d88\u606fID[" + logVo.getId() + "]");
        }
    }

    private void sendMqExceptionSaveLog(RocketMqMessageLogDocument logVo, MqMessageVo mqMessageVo, Exception e) {
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25:mqMessageVo = {} >>>", (Object)JSON.toJSONString((Object)mqMessageVo), (Object)e);
        logVo.setSendLog(ExceptionUtils.getStackTrace((Throwable)e));
        if (!StringUtils.hasText((String)logVo.getSendLog())) {
            logVo.setSendLog("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        logVo.setSendStatus(EnableStatusEnum.DISABLE.getCode());
        if (RocketMqUtil.isSaveLog()) {
            this.rocketMqMessageLogDocumentRepository.save(logVo);
        }
    }

    private RocketMqMessageLogDocument buildMqLog(MqMessageVo mqMessageVo) {
        if (this.buildMqInfoExtendService != null) {
            return this.buildMqInfoExtendService.buildMqLog(mqMessageVo);
        }
        if (!StringUtils.hasText((String)mqMessageVo.getCurrentAccount())) {
            mqMessageVo.setCurrentAccount(Objects.isNull(this.loginUserService) ? "" : this.loginUserService.getLoginAccountName());
        }
        if (!StringUtils.hasText((String)mqMessageVo.getAccountJson())) {
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            mqMessageVo.setAccountJson(Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity));
        }
        RocketMqMessageLogDocument logDocument = RocketMqMessageLogDocument.buildLogVo(mqMessageVo);
        RocketMqUtil.checkSendMsg(logDocument);
        if (RocketMqUtil.isSaveLog()) {
            try {
                logDocument = (RocketMqMessageLogDocument)this.rocketMqMessageLogDocumentRepository.save(logDocument);
            }
            catch (IllegalStateException | NoNodeAvailableException e) {
                log.error(e.getMessage(), e);
                String errorMsg = RocketMqUtil.buildErrorInfo();
                log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,elasticsearch\u5f02\u5e38!\n[{}]", (Object)errorMsg);
                if (this.mqExceptionExtendService != null) {
                    this.mqExceptionExtendService.sendMqException((Exception)e);
                }
                throw new IllegalArgumentException(errorMsg);
            }
            this.redisService.set("mq:message:" + logDocument.getId(), (Object)logDocument, 600L);
        } else {
            logDocument.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        mqMessageVo.setId(logDocument.getId());
        return logDocument;
    }

    @Async
    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={RocketMqProducerEvent.class})
    public void onRocketMqProducerEvent(RocketMqProducerEvent event) {
        if (event == null || CollectionUtils.isEmpty((Collection)event.getGroupList()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)event.getMsgBody()) || !StringUtils.hasText((String)event.getTag())) {
            log.error("\u4e8b\u52a1\u5b8c\u6210\u540e\u53d1\u9001MQ\u6d88\u606f\u5931\u8d25");
            return;
        }
        String topic = event.getTopic();
        String tag = event.getTag();
        boolean isOrder = event.isOrder();
        String shardingKey = event.getShardingKey();
        if (isOrder && !StringUtils.hasText((String)shardingKey)) {
            shardingKey = tag;
        }
        String currentAccount = event.getCurrentAccount();
        String accountJson = event.getAccountJson();
        String businessKey = event.getBusinessKey();
        String businessType = event.getBusinessType();
        String operationType = event.getOperationType();
        String remarks = event.getRemarks();
        if (!StringUtils.isEmpty((Object)event.getMsgBody())) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setTopic(topic);
            mqMessageVo.setTag(tag);
            mqMessageVo.setMsgBody(event.getMsgBody());
            mqMessageVo.setCurrentAccount(currentAccount);
            mqMessageVo.setAccountJson(accountJson);
            mqMessageVo.setBusinessKey(businessKey);
            mqMessageVo.setBusinessType(businessType);
            mqMessageVo.setOperationType(operationType);
            mqMessageVo.setRemarks(remarks);
            if (isOrder) {
                this.sendMqOrderMsg(mqMessageVo, shardingKey);
            } else {
                this.sendMqMsg(mqMessageVo);
            }
            return;
        }
        Integer size = event.getGroupSize();
        if (size == null) {
            size = this.DEF_SIZE;
        }
        List orderFormIdGroupList = Lists.partition((List)event.getGroupList(), (int)size);
        AtomicInteger sentCountAtomic = new AtomicInteger(0);
        String finalShardingKey = shardingKey;
        orderFormIdGroupList.stream().filter(k -> !CollectionUtils.isEmpty((Collection)k)).forEach(list -> {
            try {
                Thread.sleep(150L);
                sentCountAtomic.getAndIncrement();
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setTopic(topic);
                mqMessageVo.setTag(tag);
                mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
                mqMessageVo.setCurrentAccount(currentAccount);
                mqMessageVo.setAccountJson(accountJson);
                mqMessageVo.setBusinessKey(businessKey);
                mqMessageVo.setBusinessType(businessType);
                mqMessageVo.setOperationType(operationType);
                mqMessageVo.setRemarks(remarks);
                if (isOrder) {
                    this.sendMqOrderMsg(mqMessageVo, finalShardingKey);
                } else {
                    this.sendMqMsg(mqMessageVo);
                }
            }
            catch (InterruptedException e) {
                log.error("MQ\u5f02\u6b65\u53d1\u9001\u6d88\u606f\u5931\u8d25 >>>");
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

