/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.bean.OrderProducerBean;
import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import com.biz.crm.business.common.rocketmq.service.MqCommonService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AlibabaMqServiceImpl
implements MqCommonService {
    private static final Logger log = LoggerFactory.getLogger(AlibabaMqServiceImpl.class);
    @Autowired(required=false)
    private ProducerBean producerBean;
    @Autowired(required=false)
    private OrderProducerBean orderProducerBean;

    @Override
    public RocketMqTypeEnum getMqTypeEnum() {
        return RocketMqTypeEnum.ALIBABA_CLOUD;
    }

    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody) {
        this.sendMqMsg(logDocument, messageBody, 0L);
    }

    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            Message msg = new Message(logDocument.getTopic(), logDocument.getTag(), JSON.toJSONString((Object)messageBody).getBytes());
            msg.setKey(logDocument.getId());
            if (deliverSecond > 0L) {
                msg.setStartDeliverTime(System.currentTimeMillis() + deliverSecond * 1000L);
            }
            SendResult sendResult = this.producerBean.send(msg);
            log.info("\u53d1\u9001MQ\u8fd4\u56de\u4fe1\u606f{}", (Object)sendResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey) {
        this.sendMqOrderMsg(logDocument, messageBody, shardingKey, 0L);
    }

    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            Message msg = new Message(logDocument.getTopic(), logDocument.getTag(), JSON.toJSONString((Object)messageBody).getBytes());
            msg.setKey(logDocument.getId());
            if (deliverSecond > 0L) {
                msg.setStartDeliverTime(System.currentTimeMillis() + deliverSecond * 1000L);
            }
            SendResult sendResult = this.orderProducerBean.send(msg, shardingKey);
            log.info("\u53d1\u9001MQ\u8fd4\u56de\u4fe1\u606f{}", (Object)sendResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

