package com.biz.crm.business.common.rocketmq.strategy.security;

import com.biz.crm.business.common.rocketmq.vo.MqUserDetailVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * MQ消费者设置用户
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.18 4:17
 */
@Slf4j
@Component
public class MqAuthenticationRefreshStrategy implements AuthenticationRefreshStrategy {

    @Override
    public int getOrder() {
        return 19;
    }

    @Override
    public boolean matched(Object info) {
        // 只有在MqUserDetailVo对象存在的情况下，创建操作者
        if (Objects.isNull(info)) {
            return false;
        }
        return info instanceof MqUserDetailVo;
    }

    @Override
    public UserIdentity refresh(Object info) {
        try {
            // 生成 User
            return (MqUserDetailVo) info;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw e;
        }
    }

}
