/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.biz.crm.business.common.base.util.DateUtil;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.repository.RocketMqMessageLogDocumentRepository;
import com.biz.crm.business.common.rocketmq.service.MqExceptionExtendService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.rocketmq.vo.MqUserDetailVo;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRocketMqConsumer
implements RocketMQListener<MqMessageVo>,
MessageListener,
MessageOrderListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractRocketMqConsumer.class);
    @Autowired(required=false)
    private RocketMqMessageLogDocumentRepository rocketMqMessageLogDocumentRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MqExceptionExtendService mqExceptionExtendService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public void onMessage(MqMessageVo message) {
        log.info("\u63a5\u6536\u5230\u7684MQ\u6d88\u606f\u5185\u5bb9{}", (Object)message);
        if (null == message) {
            log.error("\u6d88\u8d39MQ\u6d88\u606fMqMessageVo\u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new IllegalArgumentException("\u6d88\u8d39MQ\u6d88\u606fMqMessageVo\u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        Exception handleException = null;
        String json = JSON.toJSONString((Object)message);
        String messageId = message.getId();
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {}", (Object)json);
            return;
        }
        String repeatKey = "mq:repeat:" + messageId;
        if (!message.isRepeatConsumer() && this.redisService.hasKey(repeatKey).booleanValue()) {
            log.error("MQ\u6d88\u606f\u5185\u5bb9\u5df2\u88ab\u6210\u529f\u6d88\u8d39,\u4e0d\u53ef\u88ab\u91cd\u590d\u6210\u529f\u6d88\u8d39\uff1amessage = {}", (Object)json);
            return;
        }
        Date beginDate = new Date();
        String callbackBegin = RocketMqUtil.DATETIME_FORMAT.format(beginDate);
        String endStatus = EnableStatusEnum.DISABLE.getCode();
        String callbackLog = "\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\u8df3\u8fc7\u4e1a\u52a1\u5904\u7406!";
        this.setUserInfo(message);
        try {
            if (StringUtils.isNotEmpty((CharSequence)message.getMsgBody())) {
                Object result = this.handleMessage(message);
                callbackLog = JSON.toJSONString((Object)result);
            }
            endStatus = EnableStatusEnum.ENABLE.getCode();
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
            callbackLog = ExceptionUtils.getStackTrace((Throwable)e);
            handleException = e;
        }
        this.saveMqConsumerLog(message, callbackBegin, callbackLog, endStatus);
        Date endDate = new Date();
        log.info("MQ\u6d88\u606f[{}] \u5f00\u59cb\u6d88\u8d39\u65f6\u95f4[{}],\u7ed3\u675f\u6d88\u8d39\u65f6\u95f4[{}],\u8017\u65f6[{}]", new Object[]{messageId, callbackBegin, RocketMqUtil.DATETIME_FORMAT.format(endDate), DateUtil.millisecondToStrVague((long)(endDate.getTime() - beginDate.getTime()))});
        if (null != handleException) {
            throw new IllegalArgumentException("\u6d88\u8d39MQ\u6d88\u606f\u5931\u8d25\uff1amessage = " + json, handleException);
        }
        this.redisMutexService.getAndIncrement("mq:repeat:" + messageId, 0L, (long)RocketMqUtil.getLockHour().intValue(), TimeUnit.HOURS);
    }

    private void setUserInfo(MqMessageVo message) {
        String currentAccount = message.getCurrentAccount();
        String accountJson = message.getAccountJson();
        if (StringUtils.isNotEmpty((CharSequence)accountJson)) {
            MqUserDetailVo userIdentity = (MqUserDetailVo)((Object)JSON.parseObject((String)accountJson, MqUserDetailVo.class));
            this.loginUserService.refreshAuthentication((Object)userIdentity);
        }
    }

    private void saveMqConsumerLog(MqMessageVo message, String callbackBegin, String callbackLog, String endStatus) {
        block12: {
            if (message == null || !RocketMqUtil.isSaveLog()) {
                return;
            }
            String messageId = message.getId();
            String json = JSON.toJSONString((Object)message);
            String redisKey = "mq:message:" + messageId;
            Object redisObj = this.redisService.get(redisKey);
            RocketMqMessageLogDocument logEntity = null;
            LocalDateTime localDateTime = LocalDateTime.now();
            if (redisObj != null) {
                logEntity = redisObj instanceof RocketMqMessageLogDocument ? (RocketMqMessageLogDocument)redisObj : (RocketMqMessageLogDocument)JSONObject.parseObject((String)JSON.toJSONString((Object)redisObj), RocketMqMessageLogDocument.class);
            } else {
                Optional logEsOptional = this.rocketMqMessageLogDocumentRepository.findById(messageId);
                if (logEsOptional.isPresent()) {
                    logEntity = (RocketMqMessageLogDocument)logEsOptional.get();
                } else {
                    logEntity = RocketMqMessageLogDocument.buildLogVo(message);
                    logEntity.setEndStatus(EnableStatusEnum.ENABLE.getCode());
                }
            }
            if (logEntity == null) {
                logEntity = RocketMqMessageLogDocument.buildLogVo(message);
                logEntity.setRemarks("\u672a\u83b7\u53d6\u5230MQ\u53d1\u9001\u65e5\u5fd7\u8bb0\u5f55,\u6d88\u8d39\u65f6,\u91cd\u65b0\u6784\u5efa");
            }
            if (StringUtils.isEmpty((CharSequence)logEntity.getTopic())) {
                logEntity.setTopic(RocketMqUtil.getTopic());
            }
            logEntity.setCallbackBegin(callbackBegin);
            logEntity.setUpdateDate(localDateTime.format(RocketMqUtil.YYYY_MM_DD));
            logEntity.setUpdateDateSecond(localDateTime.format(RocketMqUtil.HH_MM_SS));
            logEntity.setUpdateDateAll(localDateTime.format(RocketMqUtil.YYYY_MM_DD_HH_MM_SS));
            logEntity.setCallbackLog(callbackLog);
            logEntity.setEndStatus(endStatus);
            try {
                logEntity.setCallbackEnd(localDateTime.format(RocketMqUtil.YYYY_MM_DD_HH_MM_SS));
                if (Objects.nonNull(logEntity.getCreateDateSort())) {
                    logEntity.setConsumeTime(System.currentTimeMillis() - logEntity.getCreateDateSort());
                }
                logEntity.setId(messageId);
                this.rocketMqMessageLogDocumentRepository.save(logEntity);
                this.redisService.del(redisKey);
            }
            catch (IllegalStateException | NoNodeAvailableException e) {
                log.error("message = {} >>>", (Object)json, (Object)e);
                log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,elasticsearch\u5f02\u5e38!\n[{}]", (Object)RocketMqUtil.buildErrorInfo());
                if (this.mqExceptionExtendService != null) {
                    this.mqExceptionExtendService.consumerMqException((Exception)e);
                }
            }
            catch (Exception e) {
                log.error("message = {} >>>", (Object)json, (Object)e);
                log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,elasticsearch\u5f02\u5e38!");
                if (this.mqExceptionExtendService == null) break block12;
                this.mqExceptionExtendService.consumerMqException(e);
            }
        }
    }

    public Action consume(Message message, ConsumeContext context) {
        if (null == message) {
            log.error("\u666e\u901a\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new IllegalArgumentException("\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        if (message.getBody() == null) {
            log.error("\u666e\u901a\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new IllegalArgumentException("\u987a\u5e8f\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        MqMessageVo mqMessageBody = (MqMessageVo)JSONObject.parseObject((byte[])message.getBody(), MqMessageVo.class, (Feature[])new Feature[0]);
        this.onMessage(mqMessageBody);
        return Action.CommitMessage;
    }

    public OrderAction consume(Message message, ConsumeOrderContext context) {
        if (null == message) {
            log.error("\u987a\u5e8f\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new IllegalArgumentException("\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        if (message.getBody() == null) {
            log.error("\u987a\u5e8f\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new IllegalArgumentException("\u987a\u5e8f\u6d88\u8d39MQ\u6d88\u606f\uff1aMqMessageVo \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        MqMessageVo mqMessageBody = (MqMessageVo)JSONObject.parseObject((byte[])message.getBody(), MqMessageVo.class, (Feature[])new Feature[0]);
        this.onMessage(mqMessageBody);
        return OrderAction.Success;
    }

    protected abstract Object handleMessage(MqMessageVo var1);
}

