package com.biz.crm.business.common.rocketmq.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * mq延迟推送配置
 * @author wanghaojia
 */
@Configuration
public class MqPushSchedulerConfiguration {
  @Autowired
  private ApplicationContext applicationContext;
  
  /**
   * Master节点状态保持者线程池
   * @return
   */
  @Bean("mqPush_dTaskMasterKeeperThreadExecutor")
  public ThreadPoolExecutor getDynamicTaskMasterKeeperThreadExecutor() {
    return new ThreadPoolExecutor(2, 2, 10, TimeUnit.SECONDS, new LinkedBlockingQueue<>(), new ThreadFactory() {
      private AtomicInteger count = new AtomicInteger(0);
      @Override
      public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, "mqPush_DynamicTask_MasterKeeperThread_" + count.incrementAndGet());
        ClassLoader classLoader = applicationContext.getClassLoader();
        thread.setContextClassLoader(classLoader);
        thread.setDaemon(false);
        return thread;
      }
    });
  }
  
  /**
   * 实际任务运行调度线程池
   * @return
   */
  @Bean("mqPush_dynamicTaskScheduler")
  public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
    ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
    scheduler.setBeanName("mqPush_dynamicTaskScheduler");
    scheduler.setDaemon(false);
    scheduler.setPoolSize(50);
    scheduler.setThreadFactory(new ThreadFactory() {
      private AtomicInteger count = new AtomicInteger(1);
      @Override
      public Thread newThread(Runnable r) {
        Thread currentThread = new Thread(r);
        ClassLoader classLoader = applicationContext.getClassLoader();
        currentThread.setDaemon(false);
        currentThread.setName("mqPush_DynamicTask_" + count.getAndIncrement());
        currentThread.setContextClassLoader(classLoader);
        return currentThread;
      }
    });
    scheduler.setThreadNamePrefix("mqPush_");
    return scheduler;
  }
}