package com.biz.crm.business.common.rocketmq.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import com.biz.crm.business.common.rocketmq.service.MqCommonService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 华为 rocketMq
 *
 * @describe MQ
 * @author huxmld
 * @version v1.0.0
 * @date 2022/10/16 17:18
 */
@Slf4j
public class HuaweiMqServiceImpl implements MqCommonService {

    @Autowired(required = false)
    private RocketMQTemplate rocketMqTemplate;

    /**
     * 获取消息类型  local
     *
     * @return string
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 17:18
     */
    @Override
    public RocketMqTypeEnum getMqTypeEnum() {
        return RocketMqTypeEnum.HUAWEI_CLOUD;
    }

    /**
     * 发送消息
     *
     * @param logDocument es日志
     * @param messageBody 消息内容
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 17:18
     */
    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody) {
        this.sendMqMsg(logDocument, messageBody, 0);
    }

    /**
     * 发送消息
     *
     * @param logDocument   es日志
     * @param messageBody   消息内容
     * @param deliverSecond 延迟时间/秒
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 17:14
     */
    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            String json = JSON.toJSONString(messageBody);
            Message message = new Message(logDocument.getTopic(), logDocument.getTag(), json.getBytes(RemotingHelper.DEFAULT_CHARSET));
            DefaultMQProducer producer = rocketMqTemplate.getProducer();
            if (deliverSecond > 0) {
                //1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h
                message.setDelayTimeLevel(RocketMqUtil.getDelayTimeLevelByDelaySecond(deliverSecond));
            }
            SendResult sendResult = producer.send(message);
            log.info("发送MQ返回信息{}", sendResult);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    /**
     * 同步发送顺序消费的消息
     *
     * @param logDocument es日志
     * @param messageBody 消息内容
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 17:18
     */
    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey) {
        this.sendMqOrderMsg(logDocument, messageBody, shardingKey, 0);
    }

    /**
     * 同步发送顺序消费的消息
     *
     * @param logDocument   es日志
     * @param messageBody   消息内容
     * @param deliverSecond 延迟时间/秒
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 17:14
     */
    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            String json = JSON.toJSONString(messageBody);
            Message message = new Message(logDocument.getTopic(), logDocument.getTag(), json.getBytes(RemotingHelper.DEFAULT_CHARSET));
            DefaultMQProducer producer = rocketMqTemplate.getProducer();
            if (deliverSecond > 0) {
                //1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h
                message.setDelayTimeLevel(RocketMqUtil.getDelayTimeLevelByDelaySecond(deliverSecond));
            }
            SendResult sendResult = producer.send(message, rocketMqTemplate.getMessageQueueSelector(), shardingKey);
            log.info("发送MQ返回信息{}", sendResult);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
