/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.config;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RocketMqConfig {
    @Value(value="${rocketmq.topic}")
    private String topic;
    @Value(value="${rocketmq.environment}")
    private String environment;
    @Value(value="${rocketmq.lockHour:8}")
    private Integer lockHour;
    @Value(value="${rocketmq.name-server}")
    private String nameServer;
    @Value(value="${rocketmq.producer.access-key:}")
    private String accessKey;
    @Value(value="${rocketmq.producer.secret-key:}")
    private String secretKey;
    @Value(value="${rocketmq.producer.group:}")
    private String groupId;
    @Value(value="${rocketmq.producer.order-group:}")
    private String orderGroupId;
    @Value(value="${rocketmq.log.clean-cron:0 0 5 * * ?}")
    private String cleanCron;
    @Value(value="${rocketmq.log.is-save-log:true}")
    private Boolean isSaveLog;
    @Value(value="${rocketmq.log.save-day:14}")
    private Integer saveDay;
    @Value(value="${rocketmq.log.min-num:10000}")
    private Long minNum;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Value(value="${spring.profiles.active:}")
    private String profilesActive;
    @Value(value="${spring.cloud.nacos.discovery.namespace:}")
    private String namespace;
    @Value(value="${spring.cloud.nacos.discovery.server-addr:}")
    private String serverAddr;
    @Value(value="${rocketmq.producer.send-message-timeout:3000}")
    private String timeout;

    public Properties getMqProperty() {
        Properties properties = new Properties();
        properties.setProperty("AccessKey", this.accessKey);
        properties.setProperty("SecretKey", this.secretKey);
        properties.setProperty("NAMESRV_ADDR", this.nameServer);
        properties.setProperty("SendMsgTimeoutMillis", this.timeout);
        return properties;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Integer getLockHour() {
        return this.lockHour;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOrderGroupId() {
        return this.orderGroupId;
    }

    public String getCleanCron() {
        return this.cleanCron;
    }

    public Boolean getIsSaveLog() {
        return this.isSaveLog;
    }

    public Integer getSaveDay() {
        return this.saveDay;
    }

    public Long getMinNum() {
        return this.minNum;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProfilesActive() {
        return this.profilesActive;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setLockHour(Integer lockHour) {
        this.lockHour = lockHour;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setOrderGroupId(String orderGroupId) {
        this.orderGroupId = orderGroupId;
    }

    public void setCleanCron(String cleanCron) {
        this.cleanCron = cleanCron;
    }

    public void setIsSaveLog(Boolean isSaveLog) {
        this.isSaveLog = isSaveLog;
    }

    public void setSaveDay(Integer saveDay) {
        this.saveDay = saveDay;
    }

    public void setMinNum(Long minNum) {
        this.minNum = minNum;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setProfilesActive(String profilesActive) {
        this.profilesActive = profilesActive;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketMqConfig)) {
            return false;
        }
        RocketMqConfig other = (RocketMqConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lockHour = this.getLockHour();
        Integer other$lockHour = other.getLockHour();
        if (this$lockHour == null ? other$lockHour != null : !((Object)this$lockHour).equals(other$lockHour)) {
            return false;
        }
        Boolean this$isSaveLog = this.getIsSaveLog();
        Boolean other$isSaveLog = other.getIsSaveLog();
        if (this$isSaveLog == null ? other$isSaveLog != null : !((Object)this$isSaveLog).equals(other$isSaveLog)) {
            return false;
        }
        Integer this$saveDay = this.getSaveDay();
        Integer other$saveDay = other.getSaveDay();
        if (this$saveDay == null ? other$saveDay != null : !((Object)this$saveDay).equals(other$saveDay)) {
            return false;
        }
        Long this$minNum = this.getMinNum();
        Long other$minNum = other.getMinNum();
        if (this$minNum == null ? other$minNum != null : !((Object)this$minNum).equals(other$minNum)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$nameServer = this.getNameServer();
        String other$nameServer = other.getNameServer();
        if (this$nameServer == null ? other$nameServer != null : !this$nameServer.equals(other$nameServer)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$orderGroupId = this.getOrderGroupId();
        String other$orderGroupId = other.getOrderGroupId();
        if (this$orderGroupId == null ? other$orderGroupId != null : !this$orderGroupId.equals(other$orderGroupId)) {
            return false;
        }
        String this$cleanCron = this.getCleanCron();
        String other$cleanCron = other.getCleanCron();
        if (this$cleanCron == null ? other$cleanCron != null : !this$cleanCron.equals(other$cleanCron)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$profilesActive = this.getProfilesActive();
        String other$profilesActive = other.getProfilesActive();
        if (this$profilesActive == null ? other$profilesActive != null : !this$profilesActive.equals(other$profilesActive)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$serverAddr = this.getServerAddr();
        String other$serverAddr = other.getServerAddr();
        if (this$serverAddr == null ? other$serverAddr != null : !this$serverAddr.equals(other$serverAddr)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketMqConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lockHour = this.getLockHour();
        result = result * 59 + ($lockHour == null ? 43 : ((Object)$lockHour).hashCode());
        Boolean $isSaveLog = this.getIsSaveLog();
        result = result * 59 + ($isSaveLog == null ? 43 : ((Object)$isSaveLog).hashCode());
        Integer $saveDay = this.getSaveDay();
        result = result * 59 + ($saveDay == null ? 43 : ((Object)$saveDay).hashCode());
        Long $minNum = this.getMinNum();
        result = result * 59 + ($minNum == null ? 43 : ((Object)$minNum).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $nameServer = this.getNameServer();
        result = result * 59 + ($nameServer == null ? 43 : $nameServer.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $orderGroupId = this.getOrderGroupId();
        result = result * 59 + ($orderGroupId == null ? 43 : $orderGroupId.hashCode());
        String $cleanCron = this.getCleanCron();
        result = result * 59 + ($cleanCron == null ? 43 : $cleanCron.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $profilesActive = this.getProfilesActive();
        result = result * 59 + ($profilesActive == null ? 43 : $profilesActive.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $serverAddr = this.getServerAddr();
        result = result * 59 + ($serverAddr == null ? 43 : $serverAddr.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        return result;
    }

    public String toString() {
        return "RocketMqConfig(topic=" + this.getTopic() + ", environment=" + this.getEnvironment() + ", lockHour=" + this.getLockHour() + ", nameServer=" + this.getNameServer() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", groupId=" + this.getGroupId() + ", orderGroupId=" + this.getOrderGroupId() + ", cleanCron=" + this.getCleanCron() + ", isSaveLog=" + this.getIsSaveLog() + ", saveDay=" + this.getSaveDay() + ", minNum=" + this.getMinNum() + ", applicationName=" + this.getApplicationName() + ", profilesActive=" + this.getProfilesActive() + ", namespace=" + this.getNamespace() + ", serverAddr=" + this.getServerAddr() + ", timeout=" + this.getTimeout() + ")";
    }
}

