package com.biz.crm.business.common.rocketmq.client;

import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * @describe 阿里MQ 无序
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:37
 */
@Conditional(AlibabaCondition.class)
@Configuration
@Slf4j
public class ProducerClient {

    @Resource
    private RocketMqConfig rocketMqConfig;

    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean buildProducer() {
        log.info("=====>    阿里rocketMq加载[{}]    <=====", ProducerBean.class.getName());
        ProducerBean producer = new ProducerBean();
        producer.setProperties(rocketMqConfig.getMqProperty());
        return producer;
    }

}
