package com.biz.crm.business.common.rocketmq.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.rocketmq.constant.MqConstant;
import com.biz.crm.business.common.rocketmq.service.MqEventDemoService;
import com.biz.crm.business.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 17:57
 */
@Slf4j
@RestController
@RequestMapping("/v1/rocketmq/rocketMqSend")
@Api(tags = "RocketMq消息队列: rocketMq")
public class RocketMqSendDemoController {

    @Resource
    private RocketMqProducer rocketMqProducer;

    @Resource
    private MqEventDemoService mqEventDemoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @ApiOperation(value = "测试rocketMq发送消息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tipMsg", value = "消息内容", dataTypeClass = String.class, paramType = "query", defaultValue = "hello,普通类型MQ消息测试。"),
            @ApiImplicitParam(name = "order", value = "是否顺序", dataTypeClass = Boolean.class, defaultValue = "false", paramType = "query"),
            @ApiImplicitParam(name = "time", value = "发送次数", dataTypeClass = String.class, defaultValue = "9", paramType = "query"),
            @ApiImplicitParam(name = "deliverSecond", value = "延迟时间/秒", dataTypeClass = Long.class, defaultValue = "0", paramType = "query"),
            @ApiImplicitParam(name = "repeatConsumer", value = "是否可重复消费", dataTypeClass = Boolean.class, defaultValue = "false", paramType = "query"),
    })
    @GetMapping(value = "sendMqMsg")
    public Result sendMqMsg(@RequestParam(value = "tipMsg") String msg,
                            @RequestParam(value = "order") Boolean order,
                            @RequestParam(value = "time") Integer time,
                            @RequestParam(value = "deliverSecond") long deliverSecond,
                            @RequestParam(value = "repeatConsumer") boolean repeatConsumer) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";

        if (loginUserService != null) {
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString(userIdentity);
            currentAccount = loginUserService.getLoginAccountName();
        }

        for (int i = 0; i < time; i++) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setCurrentAccount(currentAccount);
            mqMessageVo.setAccountJson(accountJson);
            mqMessageVo.setRepeatConsumer(repeatConsumer);
            mqMessageVo.setTag(MqConstant.TAG_TEST);
            mqMessageVo.setMsgBody("消息[" + i + "]" + msg);
            mqMessageVo.setMsgNum(1);
            if (Objects.nonNull(order) && order) {
                rocketMqProducer.sendMqOrderMsg(mqMessageVo, uuid, deliverSecond);
            } else {
                rocketMqProducer.sendMqMsg(mqMessageVo, deliverSecond);
            }
        }
        return Result.ok();
    }

    @ApiOperation(value = "测试rocketMq消息(事务完成后)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tipMsg", value = "消息内容", dataTypeClass = String.class, paramType = "query", defaultValue = "hello,事件类型MQ消息测试。"),
            @ApiImplicitParam(name = "order", value = "是否顺序", dataTypeClass = Boolean.class, defaultValue = "false", paramType = "query"),
            @ApiImplicitParam(name = "time", value = "编码编码", dataTypeClass = String.class, defaultValue = "9", paramType = "query"),
            @ApiImplicitParam(name = "deliverSecond", value = "延迟时间/秒", dataTypeClass = Long.class, defaultValue = "0", paramType = "query"),
            @ApiImplicitParam(name = "repeatConsumer", value = "是否可重复消费", dataTypeClass = Boolean.class, defaultValue = "false", paramType = "query"),
    })
    @GetMapping(value = "sendMqEventMsg")
    public Result sendMqEventMsg(@RequestParam(value = "tipMsg") String msg,
                                 @RequestParam(value = "order") Boolean order,
                                 @RequestParam(value = "time") Integer time,
                                 @RequestParam(value = "deliverSecond") long deliverSecond,
                                 @RequestParam(value = "repeatConsumer") boolean repeatConsumer) {
        Assert.notNull(time, "发送次数不能为空!");
        Assert.isTrue(time > 0, "发送次数不能小于1!");
        List<String> list = new ArrayList<>();
        for (int i = 0; i < time; i++) {
            list.add("消息[" + i + "]" + msg);
        }
        mqEventDemoService.sendMqEventDemo(order, list, deliverSecond, repeatConsumer);
        return Result.ok();
    }

    @ApiOperation(value = "获取当前MQ类型")
    @GetMapping(value = "getCurrentMqType")
    public Result getCurrentMqType() {
        JSONObject jsonObject = new JSONObject();
        RocketMqTypeEnum typeEnum = rocketMqProducer.getCurrentMqType();
        jsonObject.put("code", typeEnum.getCode());
        jsonObject.put("desc", typeEnum.getDesc());
        return Result.ok(jsonObject);
    }
}