package com.biz.crm.business.common.rocketmq.config;

import com.aliyun.openservices.ons.api.PropertyKeyConst;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * @describe rocketmq 连接参数
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:37
 */
@Configuration
@Data
public class RocketMqConfig {

    /**
     * 默认topic
     */
    @Value("${rocketmq.topic}")
    private String topic;

    /**
     * 环境
     */
    @Value("${rocketmq.environment}")
    private String environment;

    /**
     * MQ消息消费成功后,锁定时间防止被重复消费
     */
    @Value("${rocketmq.lockHour:8}")
    private Integer lockHour;

    @Value("${rocketmq.name-server}")
    private String nameServer;

    @Value("${rocketmq.producer.access-key:}")
    private String accessKey;

    @Value("${rocketmq.producer.secret-key:}")
    private String secretKey;
    /**
     * group ID 普通
     */
    @Value("${rocketmq.producer.group:}")
    private String groupId;
    /**
     * group ID  有序
     */
    @Value("${rocketmq.producer.order-group:}")
    private String orderGroupId;

    /**
     * 定时任务清理日志时间
     */
    @Value("${rocketmq.log.clean-cron:0 0 5 * * ?}")
    private String cleanCron;
    /**
     * 是否保存日志:默认保存  true:保存日志;false:不保存日志
     */
    @Value("${rocketmq.log.is-save-log:true}")
    private Boolean isSaveLog;
    /**
     * 日志保留天数
     */
    @Value("${rocketmq.log.save-day:14}")
    private Integer saveDay;
    /**
     * 日志最小保有量
     */
    @Value("${rocketmq.log.min-num:10000}")
    private Long minNum;


    @Value("${spring.application.name:}")
    private String applicationName;

    @Value("${spring.profiles.active:}")
    private String profilesActive;

    @Value("${spring.cloud.nacos.discovery.namespace:}")
    private String namespace;

    @Value("${spring.cloud.nacos.discovery.server-addr:}")
    private String serverAddr;


    /**
     * 如需其他的分组  可以在这里定义,启动加载  消费者可在这里获取 groupId
     * 其他groupId 可在这里配置
     */

    /**
     * 发送消息超时时间 毫秒
     */
    @Value("${rocketmq.producer.send-message-timeout:3000}")
    private String timeout;

    public Properties getMqProperty() {
        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.AccessKey, this.accessKey);
        properties.setProperty(PropertyKeyConst.SecretKey, this.secretKey);
        properties.setProperty(PropertyKeyConst.NAMESRV_ADDR, this.nameServer);
        properties.setProperty(PropertyKeyConst.SendMsgTimeoutMillis, timeout);
        return properties;
    }
}
