package com.biz.crm.business.common.rocketmq.event;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * mq 消息异步时间
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 18:57
 */
@Setter
@Getter
public class RocketMqProducerEvent extends ApplicationEvent {

    private static final long serialVersionUID = -1245674831774879595L;

    @ApiModelProperty("当前操作人，为空时会自动设置")
    private String currentAccount;

    @ApiModelProperty("当前操作人JSON")
    private String accountJson;


    @ApiModelProperty("TOPIC 主题，系统会默认使用 rocketmq.topic ;不建议传入自定义TOPIC")
    private String topic;

    @ApiModelProperty("息标签列表,必传。Consumer 根据标签消费消息;一个消息只能有一个标签")
    @NotNull
    private String tag;

    @ApiModelProperty("是否顺序队列")
    private boolean isOrder;

    @ApiModelProperty("顺序队列时,必填,为空系统默认未tag")
    private String shardingKey;

    @ApiModelProperty("该消息自定义业务标识一级，选传(默认:default)。")
    private String businessKey;

    @ApiModelProperty("消息业务key二级,选传")
    private String businessType;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("消息体，选传，msgBody不为空则只传msgBody里面的内容，groupList无效")
    private String msgBody;

    @ApiModelProperty("消息内容集合")
    private List groupList;

    @ApiModelProperty("消息集合拆分每组大小,未传默认200个一组")
    private Integer groupSize;

    @ApiModelProperty("消息延迟消费时间/秒")
    private long deliverSecond;

    @ApiModelProperty("是否可成功重复消费[广播用到或其他场景]")
    private boolean repeatConsumer;

    /**
     * 使用此构造函数，msgBody不为空则只传msgBody里面的内容
     */
    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String topic,
                                 String tag,
                                 String msgBody) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.topic = topic;
        this.tag = tag;
        this.msgBody = msgBody;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 String tag,
                                 List groupList,
                                 Integer groupSize) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.repeatConsumer = repeatConsumer;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 long deliverSecond) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.deliverSecond = deliverSecond;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 long deliverSecond,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.deliverSecond = deliverSecond;
        this.repeatConsumer = repeatConsumer;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 long deliverSecond) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.deliverSecond = deliverSecond;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 long deliverSecond,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.deliverSecond = deliverSecond;
        this.repeatConsumer = repeatConsumer;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 long deliverSecond) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.deliverSecond = deliverSecond;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 long deliverSecond,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.deliverSecond = deliverSecond;
        this.repeatConsumer = repeatConsumer;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
    }


    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType,
                                 long deliverSecond) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
        this.deliverSecond = deliverSecond;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType,
                                 long deliverSecond,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
        this.deliverSecond = deliverSecond;
        this.repeatConsumer = repeatConsumer;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType,
                                 String remarks) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
        this.remarks = remarks;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType,
                                 String remarks,
                                 long deliverSecond) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
        this.remarks = remarks;
        this.deliverSecond = deliverSecond;
    }

    public RocketMqProducerEvent(Object source,
                                 String currentAccount,
                                 String accountJson,
                                 boolean isOrder,
                                 String shardingKey,
                                 String tag,
                                 List groupList,
                                 Integer groupSize,
                                 String businessKey,
                                 String businessType,
                                 String operationType,
                                 String remarks,
                                 long deliverSecond,
                                 boolean repeatConsumer) {
        super(source);
        this.currentAccount = currentAccount;
        this.accountJson = accountJson;
        this.isOrder = isOrder;
        this.shardingKey = shardingKey;
        this.tag = tag;
        this.groupList = groupList;
        this.groupSize = groupSize;
        this.businessKey = businessKey;
        this.businessType = businessType;
        this.operationType = operationType;
        this.remarks = remarks;
        this.deliverSecond = deliverSecond;
        this.repeatConsumer = repeatConsumer;
    }

}
