package com.biz.crm.business.common.rocketmq.listener;

import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.util.ApplicationContextUtils;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

/**
 * 阿里云MQ队列
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2021/9/7 10:21
 */
@Conditional(AlibabaCondition.class)
@Slf4j
@Component
public class AlibabaMqListenerUtil {

    public Object handleMessage(Map<String, Map<String, Set<String>>> topicBeanMap, MqMessageVo message) {
        Assert.notEmpty(topicBeanMap, "消费者关系不能为空!");
        Map<String, Set<String>> tagMap = topicBeanMap.get(message.getTopic());
        Assert.notEmpty(tagMap, "topic[" + message.getTopic() + "]未找到tag!");
        Set<String> serviceNameSet = tagMap.get(message.getTag());
        //获取当前消费者 未找到有序消费者 报错
        Assert.notEmpty(serviceNameSet, "topic[" + message.getTopic() + "]" +
                "tag[" + message.getTag() + "]未找到消费者");
        serviceNameSet.forEach(serviceName -> {
            try {
                Object bean = ApplicationContextUtils.getContext().getBean(serviceName);
                Class<?> forName = bean.getClass();
                Method method = forName.getDeclaredMethod("handleMessage", MqMessageVo.class);
                method.setAccessible(true);
                method.invoke(bean, message);
            } catch (NoSuchMethodException | SecurityException e) {
                log.error(e.getMessage(), e);
                throw new IllegalArgumentException("消费失败,获取执行类失败!");
            } catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), e);
                throw new IllegalArgumentException("消费失败,执行方法!");
            } catch (InvocationTargetException e) {
                log.error("映射的方法执行异常=====>");
                log.error("[{}]", ExceptionUtils.getStackTrace(e));
                log.error(e.getMessage(), e);
                throw new RuntimeException(e);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        });
        return "消费成功.";
    }
}
