/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.document;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="rocket_mq_message_log")
public class RocketMqMessageLogDocument
implements Serializable {
    private static final long serialVersionUID = -5654659488861655509L;
    @Id
    private String id;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="\u5f53\u524d\u64cd\u4f5c\u4eba\uff0c\u4e3a\u7a7a\u65f6\u4f1a\u81ea\u52a8\u8bbe\u7f6e")
    private String currentAccount;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="MQ\u7684topic")
    private String topic;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="MQ\u7684tag")
    private String tag;
    @Field(type=FieldType.Text, index=false)
    @ApiModelProperty(value="\u6d88\u606f\u4f53")
    private String msgBody;
    @Field(type=FieldType.Integer, index=false)
    @ApiModelProperty(value="\u6d88\u606f\u5305\u542b\u5bf9\u8c61\u6570\u91cf")
    private Integer msgNum;
    @Field(type=FieldType.Text, index=false)
    @ApiModelProperty(value="\u53d1\u9001\u65e5\u5fd7")
    private String sendLog;
    @Field(type=FieldType.Text, index=false)
    @ApiModelProperty(value="\u56de\u8c03\u65e5\u5fd7")
    private String callbackLog;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u56de\u8c03\u5f00\u59cb")
    private String callbackBegin;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u56de\u8c03\u7ed3\u675f")
    private String callbackEnd;
    @Field(type=FieldType.Long)
    @ApiModelProperty(value="\u5904\u7406\u65f6\u95f4(\u6beb\u79d2)")
    private Long consumeTime;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u53d1\u9001\u72b6\u6001 009 \u6210\u529f 003 \u5931\u8d25")
    private String sendStatus;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u63a5\u6536\u72b6\u6001 009 \u6210\u529f 003 \u5931\u8d25")
    private String endStatus;
    @Field(type=FieldType.Long)
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4\u6233")
    private Long createDateSort;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u521b\u5efa\u65e5\u671f")
    private String createDate;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u521b\u5efa \u65f6\u5206\u79d2")
    private String createDateSecond;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u53d1\u9001\u65f6\u95f4")
    private String createDateAll;
    @ApiModelProperty(value="\u4fee\u6539\u65e5\u671f")
    @Field(type=FieldType.Text)
    private String updateDate;
    @ApiModelProperty(value="\u4fee\u6539")
    @Field(type=FieldType.Text)
    private String updateDateSecond;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u6700\u8fd1\u4e00\u6b21\u63a5\u6536\u65f6\u95f4")
    private String updateDateAll;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="\u6d88\u606f\u4e1a\u52a1key\u4e00\u7ea7,\u9009\u4f20")
    private String businessKey;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="\u6d88\u606f\u4e1a\u52a1key\u4e8c\u7ea7,\u9009\u4f20")
    private String businessType;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u64cd\u4f5c\u7c7b\u578b")
    private String operationType;
    @Field(type=FieldType.Text, index=false)
    @ApiModelProperty(value="\u5907\u6ce8")
    private String remarks;

    public static RocketMqMessageLogDocument buildLogVo(MqMessageVo mqMessageVo) {
        RocketMqMessageLogDocument logEntity = new RocketMqMessageLogDocument();
        logEntity.setCurrentAccount(mqMessageVo.getCurrentAccount());
        logEntity.setTopic(mqMessageVo.getTopic());
        logEntity.setTag(mqMessageVo.getTag());
        logEntity.setMsgBody(mqMessageVo.getMsgBody());
        logEntity.setMsgNum(mqMessageVo.getMsgNum());
        logEntity.setSendLog("MQ\u6d88\u606f\u53d1\u9001\u6210\u529f.");
        logEntity.setSendStatus(EnableStatusEnum.ENABLE.getCode());
        logEntity.setEndStatus(EnableStatusEnum.DISABLE.getCode());
        LocalDateTime now = LocalDateTime.now();
        logEntity.setCreateDateSort(System.currentTimeMillis());
        logEntity.setCreateDate(now.format(RocketMqUtil.YYYY_MM_DD));
        logEntity.setCreateDateSecond(now.format(RocketMqUtil.HH_MM_SS));
        logEntity.setCreateDateAll(now.format(RocketMqUtil.YYYY_MM_DD_HH_MM_SS));
        logEntity.setBusinessKey(StringUtils.isNotEmpty((CharSequence)mqMessageVo.getBusinessKey()) ? mqMessageVo.getBusinessKey() : "default");
        logEntity.setBusinessType(mqMessageVo.getBusinessType());
        logEntity.setOperationType(mqMessageVo.getOperationType());
        logEntity.setRemarks(mqMessageVo.getRemarks());
        return logEntity;
    }

    public String getId() {
        return this.id;
    }

    public String getCurrentAccount() {
        return this.currentAccount;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public String getMsgBody() {
        return this.msgBody;
    }

    public Integer getMsgNum() {
        return this.msgNum;
    }

    public String getSendLog() {
        return this.sendLog;
    }

    public String getCallbackLog() {
        return this.callbackLog;
    }

    public String getCallbackBegin() {
        return this.callbackBegin;
    }

    public String getCallbackEnd() {
        return this.callbackEnd;
    }

    public Long getConsumeTime() {
        return this.consumeTime;
    }

    public String getSendStatus() {
        return this.sendStatus;
    }

    public String getEndStatus() {
        return this.endStatus;
    }

    public Long getCreateDateSort() {
        return this.createDateSort;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getCreateDateSecond() {
        return this.createDateSecond;
    }

    public String getCreateDateAll() {
        return this.createDateAll;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public String getUpdateDateSecond() {
        return this.updateDateSecond;
    }

    public String getUpdateDateAll() {
        return this.updateDateAll;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCurrentAccount(String currentAccount) {
        this.currentAccount = currentAccount;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setMsgBody(String msgBody) {
        this.msgBody = msgBody;
    }

    public void setMsgNum(Integer msgNum) {
        this.msgNum = msgNum;
    }

    public void setSendLog(String sendLog) {
        this.sendLog = sendLog;
    }

    public void setCallbackLog(String callbackLog) {
        this.callbackLog = callbackLog;
    }

    public void setCallbackBegin(String callbackBegin) {
        this.callbackBegin = callbackBegin;
    }

    public void setCallbackEnd(String callbackEnd) {
        this.callbackEnd = callbackEnd;
    }

    public void setConsumeTime(Long consumeTime) {
        this.consumeTime = consumeTime;
    }

    public void setSendStatus(String sendStatus) {
        this.sendStatus = sendStatus;
    }

    public void setEndStatus(String endStatus) {
        this.endStatus = endStatus;
    }

    public void setCreateDateSort(Long createDateSort) {
        this.createDateSort = createDateSort;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setCreateDateSecond(String createDateSecond) {
        this.createDateSecond = createDateSecond;
    }

    public void setCreateDateAll(String createDateAll) {
        this.createDateAll = createDateAll;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public void setUpdateDateSecond(String updateDateSecond) {
        this.updateDateSecond = updateDateSecond;
    }

    public void setUpdateDateAll(String updateDateAll) {
        this.updateDateAll = updateDateAll;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketMqMessageLogDocument)) {
            return false;
        }
        RocketMqMessageLogDocument other = (RocketMqMessageLogDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$msgNum = this.getMsgNum();
        Integer other$msgNum = other.getMsgNum();
        if (this$msgNum == null ? other$msgNum != null : !((Object)this$msgNum).equals(other$msgNum)) {
            return false;
        }
        Long this$consumeTime = this.getConsumeTime();
        Long other$consumeTime = other.getConsumeTime();
        if (this$consumeTime == null ? other$consumeTime != null : !((Object)this$consumeTime).equals(other$consumeTime)) {
            return false;
        }
        Long this$createDateSort = this.getCreateDateSort();
        Long other$createDateSort = other.getCreateDateSort();
        if (this$createDateSort == null ? other$createDateSort != null : !((Object)this$createDateSort).equals(other$createDateSort)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$currentAccount = this.getCurrentAccount();
        String other$currentAccount = other.getCurrentAccount();
        if (this$currentAccount == null ? other$currentAccount != null : !this$currentAccount.equals(other$currentAccount)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$msgBody = this.getMsgBody();
        String other$msgBody = other.getMsgBody();
        if (this$msgBody == null ? other$msgBody != null : !this$msgBody.equals(other$msgBody)) {
            return false;
        }
        String this$sendLog = this.getSendLog();
        String other$sendLog = other.getSendLog();
        if (this$sendLog == null ? other$sendLog != null : !this$sendLog.equals(other$sendLog)) {
            return false;
        }
        String this$callbackLog = this.getCallbackLog();
        String other$callbackLog = other.getCallbackLog();
        if (this$callbackLog == null ? other$callbackLog != null : !this$callbackLog.equals(other$callbackLog)) {
            return false;
        }
        String this$callbackBegin = this.getCallbackBegin();
        String other$callbackBegin = other.getCallbackBegin();
        if (this$callbackBegin == null ? other$callbackBegin != null : !this$callbackBegin.equals(other$callbackBegin)) {
            return false;
        }
        String this$callbackEnd = this.getCallbackEnd();
        String other$callbackEnd = other.getCallbackEnd();
        if (this$callbackEnd == null ? other$callbackEnd != null : !this$callbackEnd.equals(other$callbackEnd)) {
            return false;
        }
        String this$sendStatus = this.getSendStatus();
        String other$sendStatus = other.getSendStatus();
        if (this$sendStatus == null ? other$sendStatus != null : !this$sendStatus.equals(other$sendStatus)) {
            return false;
        }
        String this$endStatus = this.getEndStatus();
        String other$endStatus = other.getEndStatus();
        if (this$endStatus == null ? other$endStatus != null : !this$endStatus.equals(other$endStatus)) {
            return false;
        }
        String this$createDate = this.getCreateDate();
        String other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !this$createDate.equals(other$createDate)) {
            return false;
        }
        String this$createDateSecond = this.getCreateDateSecond();
        String other$createDateSecond = other.getCreateDateSecond();
        if (this$createDateSecond == null ? other$createDateSecond != null : !this$createDateSecond.equals(other$createDateSecond)) {
            return false;
        }
        String this$createDateAll = this.getCreateDateAll();
        String other$createDateAll = other.getCreateDateAll();
        if (this$createDateAll == null ? other$createDateAll != null : !this$createDateAll.equals(other$createDateAll)) {
            return false;
        }
        String this$updateDate = this.getUpdateDate();
        String other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !this$updateDate.equals(other$updateDate)) {
            return false;
        }
        String this$updateDateSecond = this.getUpdateDateSecond();
        String other$updateDateSecond = other.getUpdateDateSecond();
        if (this$updateDateSecond == null ? other$updateDateSecond != null : !this$updateDateSecond.equals(other$updateDateSecond)) {
            return false;
        }
        String this$updateDateAll = this.getUpdateDateAll();
        String other$updateDateAll = other.getUpdateDateAll();
        if (this$updateDateAll == null ? other$updateDateAll != null : !this$updateDateAll.equals(other$updateDateAll)) {
            return false;
        }
        String this$businessKey = this.getBusinessKey();
        String other$businessKey = other.getBusinessKey();
        if (this$businessKey == null ? other$businessKey != null : !this$businessKey.equals(other$businessKey)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        return !(this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketMqMessageLogDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $msgNum = this.getMsgNum();
        result = result * 59 + ($msgNum == null ? 43 : ((Object)$msgNum).hashCode());
        Long $consumeTime = this.getConsumeTime();
        result = result * 59 + ($consumeTime == null ? 43 : ((Object)$consumeTime).hashCode());
        Long $createDateSort = this.getCreateDateSort();
        result = result * 59 + ($createDateSort == null ? 43 : ((Object)$createDateSort).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $currentAccount = this.getCurrentAccount();
        result = result * 59 + ($currentAccount == null ? 43 : $currentAccount.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $msgBody = this.getMsgBody();
        result = result * 59 + ($msgBody == null ? 43 : $msgBody.hashCode());
        String $sendLog = this.getSendLog();
        result = result * 59 + ($sendLog == null ? 43 : $sendLog.hashCode());
        String $callbackLog = this.getCallbackLog();
        result = result * 59 + ($callbackLog == null ? 43 : $callbackLog.hashCode());
        String $callbackBegin = this.getCallbackBegin();
        result = result * 59 + ($callbackBegin == null ? 43 : $callbackBegin.hashCode());
        String $callbackEnd = this.getCallbackEnd();
        result = result * 59 + ($callbackEnd == null ? 43 : $callbackEnd.hashCode());
        String $sendStatus = this.getSendStatus();
        result = result * 59 + ($sendStatus == null ? 43 : $sendStatus.hashCode());
        String $endStatus = this.getEndStatus();
        result = result * 59 + ($endStatus == null ? 43 : $endStatus.hashCode());
        String $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : $createDate.hashCode());
        String $createDateSecond = this.getCreateDateSecond();
        result = result * 59 + ($createDateSecond == null ? 43 : $createDateSecond.hashCode());
        String $createDateAll = this.getCreateDateAll();
        result = result * 59 + ($createDateAll == null ? 43 : $createDateAll.hashCode());
        String $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : $updateDate.hashCode());
        String $updateDateSecond = this.getUpdateDateSecond();
        result = result * 59 + ($updateDateSecond == null ? 43 : $updateDateSecond.hashCode());
        String $updateDateAll = this.getUpdateDateAll();
        result = result * 59 + ($updateDateAll == null ? 43 : $updateDateAll.hashCode());
        String $businessKey = this.getBusinessKey();
        result = result * 59 + ($businessKey == null ? 43 : $businessKey.hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        return result;
    }

    public String toString() {
        return "RocketMqMessageLogDocument(id=" + this.getId() + ", currentAccount=" + this.getCurrentAccount() + ", topic=" + this.getTopic() + ", tag=" + this.getTag() + ", msgBody=" + this.getMsgBody() + ", msgNum=" + this.getMsgNum() + ", sendLog=" + this.getSendLog() + ", callbackLog=" + this.getCallbackLog() + ", callbackBegin=" + this.getCallbackBegin() + ", callbackEnd=" + this.getCallbackEnd() + ", consumeTime=" + this.getConsumeTime() + ", sendStatus=" + this.getSendStatus() + ", endStatus=" + this.getEndStatus() + ", createDateSort=" + this.getCreateDateSort() + ", createDate=" + this.getCreateDate() + ", createDateSecond=" + this.getCreateDateSecond() + ", createDateAll=" + this.getCreateDateAll() + ", updateDate=" + this.getUpdateDate() + ", updateDateSecond=" + this.getUpdateDateSecond() + ", updateDateAll=" + this.getUpdateDateAll() + ", businessKey=" + this.getBusinessKey() + ", businessType=" + this.getBusinessType() + ", operationType=" + this.getOperationType() + ", remarks=" + this.getRemarks() + ")";
    }
}

