package com.biz.crm.business.common.rocketmq.enums;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashSet;
import java.util.Set;

/**
 * MQ类型
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 21:05
 */
@Getter
@AllArgsConstructor
public enum RocketMqTypeEnum {
    LOCAL("LOCAL", "本地rocketMq"),
    CLOUD("CLOUD", "云MQ"),
    ALIBABA_CLOUD("ALIBABA_CLOUD", "阿里云MQ"),
    HUAWEI_CLOUD("HUAWEI_CLOUD", "华为云MQ"),
    ;

    /**
     * key
     */
    private final String code;
    /**
     * 描述
     */
    private final String desc;

    /**
     * 获取编码集合
     *
     * @return
     */
    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        for (RocketMqTypeEnum value : values()) {
            codes.add(value.getCode());
        }
        return codes;
    }

    /**
     * 根据编码获取枚举信息
     *
     * @return
     */
    public static RocketMqTypeEnum codeToEnum(String code) {
        RocketMqTypeEnum typeEnum = null;
        for (RocketMqTypeEnum value : values()) {
            if (value.code.equals(code)) {
                typeEnum = value;
            }
        }
        return typeEnum;
    }

    /**
     * 根据编码获取描述信息
     *
     * @return String
     */
    public static String getDesc(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (RocketMqTypeEnum value : values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    /**
     * 判断编码是否存在
     *
     * @return boolean
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        for (RocketMqTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

}
