package com.biz.crm.business.common.rocketmq.document;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.biz.crm.business.common.rocketmq.constant.MqConstant;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @describe mq消息  es  日志
 * @author huxmld
 * @version v1.0.0
 * @date 2022/10/16 16:30
 */
@Document(indexName = MqConstant.ROCKET_MQ_MESSAGE_LOG_INDEX)
@Data
public class RocketMqMessageLogDocument implements Serializable {

    private static final long serialVersionUID = -5654659488861655509L;

    @Id
    private String id;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty("当前操作人，为空时会自动设置")
    private String currentAccount;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty("MQ的topic")
    private String topic;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty("MQ的tag")
    private String tag;

    /**
     * 消息体
     */
    @Field(type = FieldType.Text, index = false)
    @ApiModelProperty("消息体")
    private String msgBody;

    /**
     * 消息包含对象数量
     */
    @Field(type = FieldType.Integer, index = false)
    @ApiModelProperty("消息包含对象数量")
    private Integer msgNum;

    /**
     * 发送日志
     */
    @Field(type = FieldType.Text, index = false)
    @ApiModelProperty("发送日志")
    private String sendLog;

    /**
     * 回调日志
     */
    @Field(type = FieldType.Text, index = false)
    @ApiModelProperty("回调日志")
    private String callbackLog;
    /**
     * 回调开始
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("回调开始")
    private String callbackBegin;
    /**
     * 回调结束
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("回调结束")
    private String callbackEnd;
    /**
     * 处理时间(毫秒)
     */
    @Field(type = FieldType.Long)
    @ApiModelProperty("处理时间(毫秒)")
    private Long consumeTime;
    /**
     * 发送状态 009 成功 003 失败
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("发送状态 009 成功 003 失败")
    private String sendStatus;
    /**
     * 接收状态 009 成功 003 失败
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("接收状态 009 成功 003 失败")
    private String endStatus;

    @Field(type = FieldType.Long)
    @ApiModelProperty("创建时间戳")
    private Long createDateSort;

    @Field(type = FieldType.Text)
    @ApiModelProperty("创建日期")
    private String createDate;

    @Field(type = FieldType.Text)
    @ApiModelProperty("创建 时分秒")
    private String createDateSecond;

    @Field(type = FieldType.Text)
    @ApiModelProperty("发送时间")
    private String createDateAll;

    @ApiModelProperty("修改日期")
    @Field(type = FieldType.Text)
    private String updateDate;

    @ApiModelProperty("修改")
    @Field(type = FieldType.Text)
    private String updateDateSecond;

    @Field(type = FieldType.Text)
    @ApiModelProperty("最近一次接收时间")
    private String updateDateAll;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty("消息业务key一级,选传")
    private String businessKey;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty("消息业务key二级,选传")
    private String businessType;

    @Field(type = FieldType.Text)
    @ApiModelProperty("操作类型")
    private String operationType;

    @Field(type = FieldType.Text, index = false)
    @ApiModelProperty("备注")
    private String remarks;

    public static RocketMqMessageLogDocument buildLogVo(MqMessageVo mqMessageVo) {
        RocketMqMessageLogDocument logEntity = new RocketMqMessageLogDocument();
        logEntity.setCurrentAccount(mqMessageVo.getCurrentAccount());
        logEntity.setTopic(mqMessageVo.getTopic());
        logEntity.setTag(mqMessageVo.getTag());
        logEntity.setMsgBody(mqMessageVo.getMsgBody());
        logEntity.setMsgNum(mqMessageVo.getMsgNum());
        logEntity.setSendLog("MQ消息发送成功.");

        logEntity.setSendStatus(EnableStatusEnum.ENABLE.getCode());
        logEntity.setEndStatus(EnableStatusEnum.DISABLE.getCode());
        LocalDateTime now = LocalDateTime.now();
        logEntity.setCreateDateSort(System.currentTimeMillis());
        logEntity.setCreateDate(now.format(RocketMqUtil.YYYY_MM_DD));
        logEntity.setCreateDateSecond(now.format(RocketMqUtil.HH_MM_SS));
        logEntity.setCreateDateAll(now.format(RocketMqUtil.YYYY_MM_DD_HH_MM_SS));

        logEntity.setBusinessKey(StringUtils.isNotEmpty(mqMessageVo.getBusinessKey()) ? mqMessageVo.getBusinessKey() : "default");
        logEntity.setBusinessType(mqMessageVo.getBusinessType());
        logEntity.setOperationType(mqMessageVo.getOperationType());
        logEntity.setRemarks(mqMessageVo.getRemarks());
        return logEntity;
    }
}
