/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.aliyun.openservices.ons.api.bean.OrderConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.listener.OrderMessageListener;
import com.biz.crm.business.common.rocketmq.util.AlibabaMqTopicAndTagUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.util.Assert;

@Conditional(value={AlibabaCondition.class})
public class RocketMqOrderConsumerClient {
    private static final Logger log = LoggerFactory.getLogger(RocketMqOrderConsumerClient.class);
    @Autowired(required=false)
    private RocketMqConfig rocketMqConfig;
    @Autowired(required=false)
    private OrderMessageListener orderMessageListener;

    public OrderConsumerBean consumerClient() {
        OrderConsumerBean orderConsumerBean = new OrderConsumerBean();
        Properties properties = this.rocketMqConfig.getMqProperty();
        properties.setProperty("MessageModel", "CLUSTERING");
        Assert.hasLength((String)this.rocketMqConfig.getOrderGroupId(), (String)"\u6d88\u8d39\u8005GroupId\u4e0d\u80fd\u4e3a\u7a7a!");
        properties.setProperty("GROUP_ID", this.rocketMqConfig.getOrderGroupId());
        properties.setProperty("PostSubscriptionWhenPull", "true");
        properties.setProperty("ConsumeThreadNums", "20");
        orderConsumerBean.setProperties(properties);
        HashMap subscriptionTable = Maps.newHashMap();
        Map<String, Map<String, Set<String>>> topicMap = AlibabaMqTopicAndTagUtil.getTopicOrderMap();
        if (CollectionUtil.isNotEmpty(topicMap)) {
            topicMap.forEach((topic, tagServiceMap) -> {
                if (CollectionUtil.isNotEmpty((Map)tagServiceMap)) {
                    Subscription orderSubscription = new Subscription();
                    orderSubscription.setTopic(topic);
                    orderSubscription.setExpression(String.join((CharSequence)"||", tagServiceMap.keySet()));
                    subscriptionTable.put(orderSubscription, this.orderMessageListener);
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Map)subscriptionTable)) {
            log.info("=====>\u963f\u91cc\u4e91rocketMq\u542f\u7528\u987a\u5e8f\u6d88\u8d39\u8005{}", (Object)subscriptionTable);
            orderConsumerBean.setSubscriptionTable((Map)subscriptionTable);
            orderConsumerBean.start();
            return orderConsumerBean;
        }
        log.warn("=====>\u963f\u91cc\u4e91rocketMq\u65e0\u987a\u5e8f\u6d88\u8d39\u8005");
        orderConsumerBean.shutdown();
        return null;
    }
}

