package com.biz.crm.business.common.rocketmq.config;

import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.config.condition.HuaweiCondition;
import com.biz.crm.business.common.rocketmq.config.condition.LocalCondition;
import com.biz.crm.business.common.rocketmq.service.MqCommonService;
import com.biz.crm.business.common.rocketmq.service.impl.AlibabaMqServiceImpl;
import com.biz.crm.business.common.rocketmq.service.impl.HuaweiMqServiceImpl;
import com.biz.crm.business.common.rocketmq.service.impl.LocalMqServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

/**
 * @describe 区分MQ类型
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:49
 */
@Configuration
@Slf4j
public class MqTypeConfig {


    @Conditional(LocalCondition.class)
    @Bean
    @ConditionalOnMissingBean(name = "LocalMqServiceExpandImpl")
    public MqCommonService initLocal() {
        log.info("=====>    启动本地自建rocketMq     <=====");
        return new LocalMqServiceImpl();
    }

    @Conditional(AlibabaCondition.class)
    @Bean
    @ConditionalOnMissingBean(name = "AlibabaMqServiceExpandImpl")
    public MqCommonService initAlibaba() {
        log.info("=====>    启动阿里rocketMq    <=====");
        return new AlibabaMqServiceImpl();
    }

    @Conditional(HuaweiCondition.class)
    @Bean
    @ConditionalOnMissingBean(name = "HuaweiMqServiceExpandImpl")
    public MqCommonService initHuawei() {
        log.info("=====>    启动华为rocketMq    <=====");
        return new HuaweiMqServiceImpl();
    }

}
