package com.biz.crm.business.common.rocketmq.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.rocketmq.constant.MqConstant;
import com.biz.crm.business.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.business.common.rocketmq.service.MqEventDemoService;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.UUID;


/**
 * 阿里 rocketMq
 *
 * @describe MQ
 * @author huxmld
 * @version v1.0.0
 * @date 2022/10/16 17:14
 */
@Slf4j
@Service
public class MqEventDemoServiceImpl implements MqEventDemoService {


    @Autowired(required = false)
    private ApplicationEventPublisher eventPublisher;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 事务提交后发送MQ 消息
     *
     * @param order
     * @param msgList
     * @param deliverSecond
     * @param repeatConsumer
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022.10.14 12:27
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sendMqEventDemo(Boolean order, List<String> msgList, long deliverSecond, boolean repeatConsumer) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (loginUserService != null) {
            currentAccount = loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString(userIdentity);
        }
        eventPublisher.publishEvent(new RocketMqProducerEvent(this, currentAccount, accountJson,
                Objects.nonNull(order) && order, uuid, MqConstant.TAG_TEST, msgList, 4, deliverSecond, repeatConsumer));

    }
}
