package com.biz.crm.business.common.rocketmq.client;

import com.aliyun.openservices.ons.api.bean.OrderProducerBean;
import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * @describe 阿里MQ 有序
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:36
 */
@Conditional(AlibabaCondition.class)
@Configuration
@Slf4j
public class OrderProducerClient {

    @Resource
    private RocketMqConfig rocketMqConfig;

    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public OrderProducerBean buildOrderProducer() {
        log.info("=====>    阿里rocketMq加载[{}]    <=====", OrderProducerBean.class.getName());
        OrderProducerBean orderProducerBean = new OrderProducerBean();
        orderProducerBean.setProperties(rocketMqConfig.getMqProperty());
        return orderProducerBean;
    }

}
