package com.biz.crm.business.common.rocketmq.service;


import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;

/**
 * MQ抽象方法
 *
 * @describe MQ
 * @author huxmld
 * @version v1.0.0
 * @date 2022/10/16 16:40
 */
public interface MqCommonService {

    /**
     * MQ类型
     *
     * @return string
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 16:40
     */
    RocketMqTypeEnum getMqTypeEnum();

    /**
     * 发送消息
     *
     * @param logDocument es日志
     * @param messageBody 消息内容
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 16:40
     */
    void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody);

    /**
     * 发送消息
     *
     * @param logDocument   es日志
     * @param messageBody   消息内容
     * @param deliverSecond 延迟时间/秒
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 16:40
     */
    void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, long deliverSecond);


    /**
     * 同步发送顺序消费的消息
     *
     * @param logDocument es日志
     * @param messageBody 消息内容
     * @param shardingKey 消息顺序唯一标记 例如订单  订单号为唯一标记,每次发送订单号一样
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 16:40
     */
    void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey);


    /**
     * 同步发送顺序消费的消息
     *
     * @param logDocument   es日志
     * @param messageBody   消息内容
     * @param shardingKey   消息顺序唯一标记 例如订单  订单号为唯一标记,每次发送订单号一样
     * @param deliverSecond 延迟时间/秒
     * @return void
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022/10/16 16:40
     */
    void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey, long deliverSecond);
}
