package com.biz.crm.business.common.rocketmq.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @describe MQ消息体
 * @author huxmld
 * @version v1.0.0
 * @date 2022/10/16 16:30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("MQ消息体")
public class MqMessageVo implements Serializable {

    private static final long serialVersionUID = -8456193793488521957L;

    @ApiModelProperty("id,自动生成，不用传")
    private String id;

    @ApiModelProperty("当前操作人，为空时会自动设置")
    private String currentAccount;

    @ApiModelProperty("当前操作人JSON")
    private String accountJson;

    @NotNull
    @ApiModelProperty("TOPIC 主题，系统会默认使用 rocketmq.topic ;不建议传入自定义TOPIC")
    private String topic;

    /**
     * 消息标签列表,必传。Consumer 根据标签消费消息
     * 一个消息只能有一个标签
     * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
     */
    @NotNull
    @ApiModelProperty("消息标签列表,必传。Consumer 根据标签消费消息, 一个消息只能有一个标签。请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护")
    private String tag;

    @ApiModelProperty("消息体，选传")
    private String msgBody;

    @ApiModelProperty("消息包含对象数量")
    private Integer msgNum;

    @ApiModelProperty("该消息自定义业务标识一级，选传(默认:default)。")
    private String businessKey;

    @ApiModelProperty("消息业务key二级,选传")
    private String businessType;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("是否可成功重复消费[广播用到或其他场景]")
    private boolean repeatConsumer;

}
