/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.util;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RocketMqUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMqUtil.class);
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static RocketMqConfig rocketMqConfig;
    public static final String ORDER = "ORDER_";
    private static String ENVIRONMENT;
    private static String TOPIC;
    private static Boolean IS_SAVE_LOG;
    private static Integer LOCK_HOUR;

    @Autowired
    public void setRocketMqConfig(RocketMqConfig feign) {
        rocketMqConfig = feign;
        IS_SAVE_LOG = Objects.isNull(rocketMqConfig.getIsSaveLog()) ? true : rocketMqConfig.getIsSaveLog();
        log.info("=====>    rocketMq\u53d1\u9001\u548c\u6d88\u8d39\u8bb0\u5f55[{}]\u4fdd\u5b58ES\u65e5\u5fd7    <=====", (Object)(IS_SAVE_LOG != false ? "\u4f1a" : "\u4e0d\u4f1a"));
        LOCK_HOUR = Objects.isNull(rocketMqConfig.getLockHour()) ? 8 : rocketMqConfig.getLockHour();
        log.info("=====>    rocketMq\u6d88\u8d39\u6210\u529f\u9501\u5b9a[{}]\u5c0f\u65f6    <=====", (Object)LOCK_HOUR);
        TOPIC = StringUtils.isEmpty((CharSequence)rocketMqConfig.getTopic()) ? "TOPIC_DEF" : rocketMqConfig.getTopic();
        log.info("=====>    rocketMq \u9ed8\u8ba4topic\u524d\u7f00[{}]    <=====", (Object)TOPIC);
        ENVIRONMENT = StringUtils.isEmpty((CharSequence)rocketMqConfig.getEnvironment()) ? "_DEF" : rocketMqConfig.getEnvironment();
        log.info("=====>    rocketMq \u73af\u5883[{}];\u62fc\u63a5\u5728\u9ed8\u8ba4topic\u524d\u7f00\u7684\u5c3e\u90e8    <=====", (Object)ENVIRONMENT);
        log.info("=====>    rocketMq \u9ed8\u8ba4\u5b9e\u9645topic[{}]    <=====", (Object)(TOPIC + ENVIRONMENT));
    }

    public static String mqEnvironment() {
        return ENVIRONMENT;
    }

    public static Integer getLockHour() {
        return LOCK_HOUR;
    }

    public static boolean isSaveLog() {
        return IS_SAVE_LOG;
    }

    public static String getTopic() {
        return TOPIC + ENVIRONMENT;
    }

    public static String getOrderTopic() {
        return ORDER + RocketMqUtil.getTopic();
    }

    public static void checkSendMsg(RocketMqMessageLogDocument logDocument) {
        Assert.hasText((String)logDocument.getTopic(), (String)"MQ\u7684topic\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)logDocument.getTag(), (String)"MQ\u7684tag\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)logDocument.getMsgBody(), (String)"MQ\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    public static String buildErrorInfo() {
        return RocketMqUtil.buildErrorInfo("");
    }

    public static String buildErrorInfo(String title) {
        StringBuilder msgBuffer = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)title)) {
            title = "\u7cfb\u7edf\u5f02\u5e38:";
        }
        msgBuffer.append(title);
        if (StringUtils.isNotEmpty((CharSequence)rocketMqConfig.getApplicationName())) {
            msgBuffer.append("\u6a21\u5757[").append(rocketMqConfig.getApplicationName()).append("]=>");
        }
        if (StringUtils.isNotEmpty((CharSequence)rocketMqConfig.getProfilesActive())) {
            msgBuffer.append("\u73af\u5883[").append(rocketMqConfig.getProfilesActive()).append("]=>");
        }
        if (StringUtils.isNotEmpty((CharSequence)rocketMqConfig.getServerAddr())) {
            msgBuffer.append("serverAddr[").append(rocketMqConfig.getServerAddr()).append("]=>");
        }
        if (StringUtils.isNotEmpty((CharSequence)rocketMqConfig.getNameServer())) {
            msgBuffer.append("namespace[").append(rocketMqConfig.getNameServer()).append("]=>");
        }
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            msgBuffer.append("IP[").append(ip).append("]=>");
        }
        catch (Exception ipExp) {
            log.error(ipExp.getMessage(), (Throwable)ipExp);
        }
        msgBuffer.append("\u8fde\u63a5ES\u51fa\u9519\uff0c\u8bf7\u5c3d\u5feb\u786e\u8ba4\u5904\u7406!");
        msgBuffer.append(LocalDateTime.now().format(YYYY_MM_DD_HH_MM_SS));
        return msgBuffer.toString();
    }

    public static int getDelayTimeLevelByDelaySecond(long delaySecond) {
        if (delaySecond < 1L) {
            return 0;
        }
        if (delaySecond == 1L) {
            return 1;
        }
        if (delaySecond <= 5L) {
            return 2;
        }
        if (delaySecond <= 10L) {
            return 3;
        }
        if (delaySecond <= 30L) {
            return 4;
        }
        if (delaySecond <= 60L) {
            return 5;
        }
        if (delaySecond <= 120L) {
            return 6;
        }
        if (delaySecond <= 180L) {
            return 7;
        }
        if (delaySecond <= 240L) {
            return 8;
        }
        if (delaySecond <= 300L) {
            return 9;
        }
        if (delaySecond <= 360L) {
            return 10;
        }
        if (delaySecond <= 420L) {
            return 11;
        }
        if (delaySecond <= 480L) {
            return 12;
        }
        if (delaySecond <= 540L) {
            return 13;
        }
        if (delaySecond <= 600L) {
            return 14;
        }
        if (delaySecond <= 1200L) {
            return 15;
        }
        if (delaySecond <= 1800L) {
            return 16;
        }
        if (delaySecond <= 3600L) {
            return 17;
        }
        return 18;
    }

    static {
        ENVIRONMENT = "_DEF";
        TOPIC = "TOPIC_DEF";
        IS_SAVE_LOG = true;
        LOCK_HOUR = 8;
    }
}

