package com.biz.crm.business.common.rocketmq.config.condition;

import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;


/**
 * @describe 判断是不是 阿里 rocketMq
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:36
 */
public class AlibabaCondition implements Condition {

    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        String property = environment.getProperty("rocketmq.access-channel");
        String propertyCloud = environment.getProperty("rocketmq.access-channel-cloud");
        return RocketMqTypeEnum.CLOUD.getCode().equalsIgnoreCase(property)
                && RocketMqTypeEnum.ALIBABA_CLOUD.getCode().equalsIgnoreCase(propertyCloud);
    }
}
