package com.biz.crm.business.common.rocketmq.listener;

import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.business.common.rocketmq.util.AlibabaMqTopicAndTagUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

/**
 * 阿里云MQ普通队列
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 22:47
 */
@Conditional(AlibabaCondition.class)
@Component
@Slf4j
public class GeneralMessageListener extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private AlibabaMqListenerUtil alibabaMqListenerUtil;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        return alibabaMqListenerUtil.handleMessage(AlibabaMqTopicAndTagUtil.getTopicMap(), message);
    }
}
