/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.rocketmq.document.RocketMqMessageLogDocument;
import com.biz.crm.business.common.rocketmq.enums.RocketMqTypeEnum;
import com.biz.crm.business.common.rocketmq.service.MqCommonService;
import com.biz.crm.business.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.business.common.rocketmq.vo.MqMessageVo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HuaweiMqServiceImpl
implements MqCommonService {
    private static final Logger log = LoggerFactory.getLogger(HuaweiMqServiceImpl.class);
    @Autowired(required=false)
    private RocketMQTemplate rocketMqTemplate;

    @Override
    public RocketMqTypeEnum getMqTypeEnum() {
        return RocketMqTypeEnum.HUAWEI_CLOUD;
    }

    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody) {
        this.sendMqMsg(logDocument, messageBody, 0L);
    }

    @Override
    public void sendMqMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            String json = JSON.toJSONString((Object)messageBody);
            Message message = new Message(logDocument.getTopic(), logDocument.getTag(), json.getBytes("UTF-8"));
            DefaultMQProducer producer = this.rocketMqTemplate.getProducer();
            if (deliverSecond > 0L) {
                message.setDelayTimeLevel(RocketMqUtil.getDelayTimeLevelByDelaySecond(deliverSecond));
            }
            SendResult sendResult = producer.send(message);
            log.info("\u53d1\u9001MQ\u8fd4\u56de\u4fe1\u606f{}", (Object)sendResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey) {
        this.sendMqOrderMsg(logDocument, messageBody, shardingKey, 0L);
    }

    @Override
    public void sendMqOrderMsg(RocketMqMessageLogDocument logDocument, MqMessageVo messageBody, String shardingKey, long deliverSecond) {
        try {
            RocketMqUtil.checkSendMsg(logDocument);
            String json = JSON.toJSONString((Object)messageBody);
            Message message = new Message(logDocument.getTopic(), logDocument.getTag(), json.getBytes("UTF-8"));
            DefaultMQProducer producer = this.rocketMqTemplate.getProducer();
            if (deliverSecond > 0L) {
                message.setDelayTimeLevel(RocketMqUtil.getDelayTimeLevelByDelaySecond(deliverSecond));
            }
            SendResult sendResult = producer.send(message, this.rocketMqTemplate.getMessageQueueSelector(), (Object)shardingKey);
            log.info("\u53d1\u9001MQ\u8fd4\u56de\u4fe1\u606f{}", (Object)sendResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

