package com.biz.crm.business.common.tmpauthpermission.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.elasticsearch.annotations.Document;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description
 * @Author lifei
 * @Date 2025/4/21 14:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("tmp_auth_permission")
@Table(
        name = "tmp_auth_permission",
        indexes = {
                @Index(name = "tmp_auth_permission_index0", columnList = "biz_key,data_value"),
                @Index(name = "tmp_auth_permission_index1", columnList = "expire_time"),
        })
@org.hibernate.annotations.Table(appliesTo = "tmp_auth_permission")
@ApiModel(value = "TmpAuthPermission", description = "临时表数据权限存放")
public class TmpAuthPermission extends UuidEntity {

    @ApiModelProperty("数据值")
    @Column(name = "data_value",columnDefinition = "VARCHAR2(64)")
    private String dataValue;

    @ApiModelProperty("线程号")
    @Column(name = "biz_key",columnDefinition = "VARCHAR2(500)")
    private String bizKey;

    @ApiModelProperty("过期时间")
    @Column(name = "expire_time",columnDefinition = "VARCHAR2(64)")
    private String expireTime;
}
