package com.biz.crm.business.common.tmpauthpermission.controller;

import com.biz.crm.business.common.base.util.DateUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.tmpauthpermission.service.TmpAuthPermissionService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @Description
 * @Author lifei
 * @Date 2025/4/21 14:53
 **/
@RestController
@RequestMapping("/v1/tmpAuthPermissionController")
@Slf4j
public class TmpAuthPermissionController {


    @Autowired(required = false)
    private TmpAuthPermissionService tmpAuthPermissionService;


    @ApiOperation(value = "删除过期时间的数据")
    @GetMapping("deleteExpireTimeData")
    public Result deleteExpireTimeData() {
        String expireTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN));
        tmpAuthPermissionService.deleteTmpAuthPermission(expireTime);
        return Result.ok();
    }
}
