package com.biz.crm.business.common.log.feign.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.log.feign.service.internal.ExternalEuropaApiFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 数据视图查询接口feign
 * @author wanghaojia
 * @date 2023/1/5 17:02
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ExternalEuropaApiFeignImpl.class)
public interface ExternalEuropaApiFeign {

    /**
     * 外部系统调用数据视图查询接口
     * @param object 查询参数对象，europaInfoCode必填
     * @return 查询结果
     */
    @PostMapping(value = "/v1/external/api/europa/query")
    Result<Page<Object>> query(@RequestBody JSONObject object);

}
