package com.biz.crm.business.common.log.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.log.feign.service.ExternalEuropaApiFeign;
import com.biz.crm.business.common.log.sdk.service.ExternalEuropaApiService;
import com.biz.crm.business.common.sdk.model.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 数据视图查询接口
 * @author wanghaojia
 * @date 2023/11/21 11:43
 */
@Service
public class ExternalEuropaApiServiceImpl implements ExternalEuropaApiService {

    @Autowired(required = false)
    private ExternalEuropaApiFeign externalEuropaApiFeign;

    /**
     * 外部系统调用数据视图查询接口
     * @param object 查询参数对象，europaInfoCode必填
     * @return 查询结果
     */
    @Override
    public Result<Page<Object>> query(JSONObject object) {
        Result<Page<Object>> result = externalEuropaApiFeign.query(object);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("数据视图查询失败：" + result.getMessage());
        }
        return result;
    }

}
