package com.biz.crm.business.common.log.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Set;

/**
 * 数据视图查询接口-提供给外部系统
 *
 * @author wanghaojia
 * @date 2023/11/23 17:04
 */
@Slf4j
@Api(
        value = "ExternalEuropaApiController",
        tags = {"数据查询引擎（欧罗巴）外部调用接口"}
)
@RestController
@RequestMapping({"/v1/external/api/europa"})
public class ExternalEuropaApiController {

    @Autowired
    private EuropaInfoVoService europaInfoVoService;
    @Autowired
    private ExecutionService executionService;
    @Autowired
    private Set<ExecutionStrategy> executionStrategies;

    private static final String EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";

    @ApiOperation("数据查询引擎正式执行接口")
    @PostMapping(value = {"/query"})
    public Result execution(HttpServletRequest request, @RequestBody JSONObject object) {
        try {
            String europaInfoCode = object.getString(EUROPA_CODE_PARAMETER_NAME);
            Validate.notBlank(europaInfoCode, "执行数据视图时，未传入对应的欧罗巴数据视图业务编号!!");
            String tenantCode = TenantUtils.getTenantCode();
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
            Validate.notNull(europaInfoVo, "执行数据视图时，未找到指定的欧罗巴数据视图基本信息，请检查!!");
            ExecutionStrategy matchedExecutionStrategy = null;
            for (ExecutionStrategy executionStrategy : executionStrategies) {
                if (executionStrategy.validate(europaInfoVo)) {
                    matchedExecutionStrategy = executionStrategy;
                    break;
                }
            }
            int pageNum = 0;
            int pageSize = 50;
            if (object.containsKey("pageNum")) {
                pageNum = object.getInteger("pageNum");
            }
            if (object.containsKey("pageSize")) {
                pageSize = object.getInteger("pageSize");
            }
            Pageable pageable = PageRequest.of(pageNum, pageSize);
            Validate.notNull(matchedExecutionStrategy, "执行数据视图时，未找到匹配的执行器，请检查数据视图数据");
            DatabaseExecuteExternalRequest invokeParamContent = new DatabaseExecuteExternalRequest();
            invokeParamContent.setPageable(pageable);
            for (Map.Entry<String, Object> entry : object.entrySet()) {
                invokeParamContent.setAttribute(entry.getKey(), entry.getValue());
            }

            ExecutionInfo executionInfo = this.executionService.execution(europaInfoVo, pageable, invokeParamContent, matchedExecutionStrategy);
            ExecuteContent executeContent = executionInfo.getExecuteContent();
            Page<Map<String, Object>> pageResult = new Page<>();
            pageResult.setTotal(executeContent.getTotalElements());
            pageResult.setSize(pageSize);
            pageResult.setRecords(executeContent.getResults());
            return Result.ok(pageResult);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("数据视图查询失败：" + e.getMessage());
        }
    }

}
