/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.local.task;

import com.biz.crm.business.common.base.service.RedisLockService;
import com.biz.crm.business.common.base.util.DateUtil;
import com.biz.crm.business.common.log.local.config.ExternalLogConfig;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.service.CleanLogExtendService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class DeleteExternalLogCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DeleteExternalLogCornTask.class);
    private static final String DEFAULT_CRON = "0 30 6 * * ?";
    private String cron = "0 30 6 * * ?";
    private boolean openClean;
    @Resource
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Resource
    private ExternalLogConfig externalLogConfig;
    @Autowired(required=false)
    private CleanLogExtendService cleanLogExtendService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    private static final String APPLICATION_NAME = "crm-mdm";

    @PostConstruct
    private void setDeleteLogCron() {
        this.setCron(this.externalLogConfig.getCleanCron());
        this.openClean = this.externalLogConfig.isOpenClean();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::deleteData, triggerContext -> {
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     \u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7:\u539f\u6765\u7684cron\uff1a[{}]]\u66f4\u65b0\u540e\u7684cron\uff1a[{}]     <=====", (Object)this.cron, (Object)cron);
        this.cron = cron;
    }

    private void deleteData() {
        String lockKey;
        block10: {
            boolean lock;
            if (!APPLICATION_NAME.equalsIgnoreCase(this.externalLogConfig.getApplicationName()) || !this.openClean) {
                return;
            }
            lockKey = "external_log:del";
            if (this.redisLockService != null && !(lock = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L))) {
                return;
            }
            log.info("=====>    \u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7 start    <=====");
            if (this.cleanLogExtendService == null) {
                try {
                    Long minNum;
                    Integer saveDay = this.externalLogConfig.getSaveDay();
                    if (saveDay == null) {
                        saveDay = 14;
                    }
                    if ((minNum = this.externalLogConfig.getMinNum()) == null) {
                        minNum = 10000L;
                    }
                    log.info("\u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7\u6e05\u7406[{}]\u5929\u53ca\u5176\u4ee5\u524d\u7684;\u6700\u5c0f\u5b58\u653e\u6570\u91cf[{}]\u6761", (Object)saveDay, (Object)minNum);
                    long totalCount = this.elasticsearchRestTemplate.count((Query)new NativeSearchQuery((QueryBuilder)QueryBuilders.boolQuery()), ExternalLogEsDocument.class);
                    if (totalCount > minNum) {
                        log.info("\u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7\u5f53\u524d\u603b[{}]\u6761,\u5927\u4e8e\u65e5\u5fd7\u4fdd\u6709\u6700\u5c0f\u91cf[{}],\u5f00\u59cb\u6e05\u7406\u65e5\u5fd7\u3002", (Object)totalCount, (Object)minNum);
                        long saveDayMillis = 86400000L * (long)saveDay.intValue();
                        long cleanMillis = System.currentTimeMillis() - saveDayMillis;
                        String cleanDate = DateUtil.date_yyyy_MM_dd_HH_mm_ss.format(new Date(cleanMillis));
                        log.info("\u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7\u6e05\u7406[{}]\u53ca\u5176\u4ee5\u524d\u7684", (Object)cleanDate);
                        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"reqDate").lte((Object)cleanDate));
                        NativeSearchQuery deleteQuery = new NativeSearchQuery((QueryBuilder)boolQueryBuilder);
                        ByQueryResponse queryResponse = this.elasticsearchRestTemplate.delete((Query)deleteQuery, ExternalLogEsDocument.class);
                        log.info("\u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7\u6e05\u7406\u6570\u91cf:[{}]\u6761", (Object)queryResponse.getDeleted());
                        break block10;
                    }
                    log.info("\u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7\u5f53\u524d\u603b[{}]\u6761,\u5c0f\u4e8e\u65e5\u5fd7\u4fdd\u6709\u6700\u5c0f\u91cf[{}],\u4e0d\u6e05\u7406\u65e5\u5fd7\u3002", (Object)totalCount, (Object)minNum);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                this.cleanLogExtendService.cleanMqLog();
            }
        }
        if (this.redisLockService != null) {
            this.redisLockService.unlock(lockKey);
        }
        log.info("=====>    \u6e05\u7406\u5916\u90e8\u7cfb\u7edfES\u65e5\u5fd7 end    <=====");
    }
}

