package com.biz.crm.business.common.log.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.service.ExternalLogService;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.service.ExternalLogVoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author huojia
 * @date 2022年10月20日 17:53
 */
@Slf4j
@Service
public class ExternalLogVoServiceImpl implements ExternalLogVoService {

    @Autowired(required = false)
    private ExternalLogService businessLogService;

    @Override
    public void addOrUpdateLog(ExternalLogDetailDto detailDto, boolean isAdd) {
        try {
            if (isAdd) {
                //不在保存到es,降低内存使用率
                this.buildAddBaseFields(detailDto);
            } else {
                this.buildUpdateBaseFields(detailDto);
                String json = JSONObject.toJSONString(detailDto);
                ExternalLogEsDocument externalLogEsDocument = JSONObject.parseObject(json, ExternalLogEsDocument.class);
                businessLogService.saveEsLog(externalLogEsDocument);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 新增时设置基础字段
     *
     * @param detailDto
     * @author huojia
     * @date 2022/10/22 16:44
     **/
    private void buildAddBaseFields(ExternalLogDetailDto detailDto) {
        if (Objects.isNull(detailDto.getReqDate())) {
            detailDto.setReqDate(new Date());
        }
    }

    /**
     * 更新时设置基础字段
     *
     * @param detailDto
     * @author huojia
     * @date 2022/10/22 16:44
     **/
    private void buildUpdateBaseFields(ExternalLogDetailDto detailDto) {
        buildAddBaseFields(detailDto);
        if (Objects.isNull(detailDto.getRespDate())) {
            detailDto.setRespDate(new Date());
        }
        if (Objects.nonNull(detailDto.getReqDate())
                && Objects.nonNull(detailDto.getRespDate())) {
            detailDto.setExecuteTime(detailDto.getRespDate().getTime() - detailDto.getReqDate().getTime());
        }
    }

    @Override
    public List<ExternalLogDetailDto> findByIdList(List<String> idList) {
        return businessLogService.findByIdList(idList);
    }
}