package com.biz.crm.business.common.log.local.repository;

import com.biz.crm.business.common.log.local.constant.LogConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.io.Serializable;

/**
 * @describe 日志
 * @author huxmld
 * @version v1.0.0
 * @date 2021/7/23 14:50
 */
@Getter
@Setter
@Document(indexName = LogConstant.ES_INDEX_NAME_EXTERNAL_LOG)
public class ExternalLogEsDocument implements Serializable {

    private static final long serialVersionUID = 7414009233660284077L;

    @Id
    private String id;

    @ApiModelProperty("请求方法")
    @Field(type = FieldType.Keyword)
    private String method;

    @ApiModelProperty("接口地址")
    @Field(type = FieldType.Keyword)
    private String requestUri;

    @ApiModelProperty("请求方法描述")
    @Field(type = FieldType.Keyword)
    private String methodMsg;

    @ApiModelProperty(name = "账号ID")
    @Field(type = FieldType.Keyword)
    private String accessId;

    @ApiModelProperty("请求加密账号")
    @Field(type = FieldType.Keyword)
    private String accessKey;

    @ApiModelProperty("请求账号")
    @Field(type = FieldType.Keyword)
    private String userName;

    @ApiModelProperty("请求账户名称")
    @Field(type = FieldType.Keyword)
    private String fullName;

    @ApiModelProperty("网关内部的某个顶级租户编号")
    @Field(type = FieldType.Keyword)
    private String tenantCode;

    @ApiModelProperty("调用类型：1、内部系统调用外部接口；2、外部系统调用内部系统接口；其他值无效")
    @Field(type = FieldType.Integer)
    private Integer invokeType;

    @ApiModelProperty("请求源")
    @Field(type = FieldType.Keyword)
    private String sourceMain;

    @ApiModelProperty("目标源")
    @Field(type = FieldType.Keyword)
    private String targetMain;

    @ApiModelProperty("状态")
    @Field(type = FieldType.Keyword)
    private String status;

    @ApiModelProperty("消息文本")
    @Field(type = FieldType.Text)
    private String tipMsg;

    @ApiModelProperty("请求时间")
//    @Field(type = FieldType.Date)
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Field(type = FieldType.Keyword)
    private String reqDate;

    @ApiModelProperty("请求head信息")
    @Field(type = FieldType.Text, analyzer = "ik_max_word")
    private String reqHead;

    @ApiModelProperty("请求数据")
    @Field(type = FieldType.Text, analyzer = "ik_max_word")
    private String reqJson;

    @ApiModelProperty("返回数据")
    @Field(type = FieldType.Text)
    private String respJson;

    @ApiModelProperty("返回数据条数")
    @Field(type = FieldType.Integer)
    private Integer respJsonSize;

    @ApiModelProperty("返回时间")
//    @Field(type = FieldType.Date)
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Field(type = FieldType.Keyword)
    private String respDate;

    /** 执行时间 */
    @Field(type = FieldType.Long)
    private Long executeTime = 0L;

    @ApiModelProperty("异常信息")
    @Field(type = FieldType.Text)
    private String exceptionStack;

    @ApiModelProperty("TOKEN")
    @Field(type = FieldType.Keyword)
    private String token;

    @ApiModelProperty("业务标记")
    @Field(type = FieldType.Keyword)
    private String businessKey;

    @ApiModelProperty("业务类型")
    @Field(type = FieldType.Keyword)
    private String businessType;

}