/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ExternalEuropaApiController", tags={"\u6570\u636e\u67e5\u8be2\u5f15\u64ce\uff08\u6b27\u7f57\u5df4\uff09\u5916\u90e8\u8c03\u7528\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/external/api/europa"})
public class ExternalEuropaApiController {
    private static final Logger log = LoggerFactory.getLogger(ExternalEuropaApiController.class);
    @Autowired(required=false)
    private EuropaInfoVoService europaInfoVoService;
    @Autowired(required=false)
    private ExecutionService executionService;
    @Autowired(required=false)
    private Set<ExecutionStrategy> executionStrategies;
    private static final String EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";

    @ApiOperation(value="\u6570\u636e\u67e5\u8be2\u5f15\u64ce\u6b63\u5f0f\u6267\u884c\u63a5\u53e3")
    @PostMapping(value={"/query"})
    public Result execution(HttpServletRequest request, @RequestBody JSONObject object) {
        try {
            String europaInfoCode = object.getString(EUROPA_CODE_PARAMETER_NAME);
            Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
            Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            ExecutionStrategy matchedExecutionStrategy = null;
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.validate(europaInfoVo)) continue;
                matchedExecutionStrategy = executionStrategy;
                break;
            }
            int pageNum = 0;
            int pageSize = 50;
            if (object.containsKey((Object)"pageNum")) {
                pageNum = object.getInteger("pageNum");
            }
            if (object.containsKey((Object)"pageSize")) {
                pageSize = object.getInteger("pageSize");
            }
            PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
            Validate.notNull((Object)matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe\u6570\u636e", (Object[])new Object[0]);
            DatabaseExecuteExternalRequest invokeParamContent = new DatabaseExecuteExternalRequest();
            invokeParamContent.setPageable((Pageable)pageable);
            for (Map.Entry entry : object.entrySet()) {
                invokeParamContent.setAttribute((String)entry.getKey(), entry.getValue());
            }
            ExecutionInfo executionInfo = this.executionService.execution(europaInfoVo, (Pageable)pageable, (RequestParameter)invokeParamContent, matchedExecutionStrategy);
            ExecuteContent executeContent = executionInfo.getExecuteContent();
            Page pageResult = new Page();
            pageResult.setTotal(executeContent.getTotalElements());
            pageResult.setSize((long)pageSize);
            pageResult.setRecords(executeContent.getResults());
            return Result.ok((Object)pageResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

