package com.biz.crm.business.common.log.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.service.ExternalLogService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogListDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author huojia
 * @date 2022年10月21日 21:01
 */
@Slf4j
@RestController
@RequestMapping("/v1/external/log")
@Api(tags = "接口日志: externalLog", hidden = true)
public class ExternalLogController {

    @Resource
    private ExternalLogService externalLogService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询分页列表", httpMethod = "GET")
    @GetMapping("/findByConditions")
    public Result<Page<ExternalLogEsDocument>> findByConditions(@PageableDefault(50) Pageable pageable, ExternalLogListDto reqVo) {
        try {
            Page<ExternalLogEsDocument> result = this.externalLogService.findByConditions(pageable, reqVo);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询分页列表-包含json字段", httpMethod = "GET")
    @GetMapping("/findContentByConditions")
    public Result<Page<ExternalLogEsDocument>> findContentByConditions(@PageableDefault(50) Pageable pageable, ExternalLogListDto reqVo) {
        try {
            reqVo.setHasContent(true);
            Page<ExternalLogEsDocument> result = this.externalLogService.findByConditions(pageable, reqVo);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查看详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "查看详情")
    @GetMapping("/findDetailById")
    public Result<ExternalLogEsDocument> findDetailById(@RequestParam(value = "id")
                                                      @ApiParam(name = "id", value = "主键") String id) {
        try {
            return Result.ok(externalLogService.findDetailById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 下载请求数据文件
     */
    @ApiOperation(value = "下载请求数据文件")
    @GetMapping("/downloadReqJsonFile")
    public ResponseEntity<ByteArrayResource> downloadReqJsonFile(@RequestParam(value = "id")
                                                      @ApiParam(name = "id", value = "主键") String id) {
        ExternalLogEsDocument detail = externalLogService.findDetailById(id);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=" + detail.getId() + ".txt");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", new Date().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));
        byte[] bytes = detail.getReqJson().getBytes();
        return ResponseEntity.ok() .headers(headers) .contentLength(bytes.length) .contentType(MediaType.parseMediaType("application/octet-stream")) .body(new ByteArrayResource(bytes));
    }

    /**
     * 下载返回数据文件
     */
    @ApiOperation(value = "下载返回数据文件")
    @GetMapping("/downloadRespJsonFile")
    public ResponseEntity<ByteArrayResource> downloadRespJsonFile(@RequestParam(value = "id")
                                                      @ApiParam(name = "id", value = "主键") String id) {
        ExternalLogEsDocument detail = externalLogService.findDetailById(id);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=" + detail.getId() + ".txt");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", new Date().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));
        byte[] bytes = detail.getRespJson().getBytes();
        return ResponseEntity.ok() .headers(headers) .contentLength(bytes.length) .contentType(MediaType.parseMediaType("application/octet-stream")) .body(new ByteArrayResource(bytes));
    }

}
