package com.biz.crm.business.common.log.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogListDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月21日 17:22
 */
public interface ExternalLogService {

    /**
     * 保存日志
     *
     * @param entity
     * @author huojia
     * @date 2022/10/21 17:55
     **/
    void saveEsLog(ExternalLogEsDocument entity);

    /**
     * 分页查询日志
     *
     * @param pageable
     * @param reqVo
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.external.business.log.sdk.vo.ExternalLogListRespVo>
     * @author huojia
     * @date 2022/10/22 19:10
     **/
    Page<ExternalLogEsDocument> findByConditions(Pageable pageable, ExternalLogListDto reqVo);

    /**
     * 获取详情
     *
     * @param id
     * @return com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.30 22:13
     */
    ExternalLogEsDocument findDetailById(String id);

    List<ExternalLogDetailDto> findByIdList(List<String> idList);

}
