/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.service.ExternalLogService;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogListDto;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/external/log"})
@Api(tags={"\u63a5\u53e3\u65e5\u5fd7: externalLog"}, hidden=true)
public class ExternalLogController {
    private static final Logger log = LoggerFactory.getLogger(ExternalLogController.class);
    @Resource
    private ExternalLogService externalLogService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ExternalLogEsDocument>> findByConditions(@PageableDefault(value=50) Pageable pageable, ExternalLogListDto reqVo) {
        try {
            Page<ExternalLogEsDocument> result = this.externalLogService.findByConditions(pageable, reqVo);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868-\u5305\u542bjson\u5b57\u6bb5", httpMethod="GET")
    @GetMapping(value={"/findContentByConditions"})
    public Result<Page<ExternalLogEsDocument>> findContentByConditions(@PageableDefault(value=50) Pageable pageable, ExternalLogListDto reqVo) {
        try {
            reqVo.setHasContent(true);
            Page<ExternalLogEsDocument> result = this.externalLogService.findByConditions(pageable, reqVo);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ExternalLogEsDocument> findDetailById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            return Result.ok((Object)this.externalLogService.findDetailById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8bf7\u6c42\u6570\u636e\u6587\u4ef6")
    @GetMapping(value={"/downloadReqJsonFile"})
    public ResponseEntity<ByteArrayResource> downloadReqJsonFile(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        ExternalLogEsDocument detail = this.externalLogService.findDetailById(id);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=" + detail.getId() + ".txt");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", new Date().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));
        byte[] bytes = detail.getReqJson().getBytes();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8fd4\u56de\u6570\u636e\u6587\u4ef6")
    @GetMapping(value={"/downloadRespJsonFile"})
    public ResponseEntity<ByteArrayResource> downloadRespJsonFile(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        ExternalLogEsDocument detail = this.externalLogService.findDetailById(id);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=" + detail.getId() + ".txt");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", new Date().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));
        byte[] bytes = detail.getRespJson().getBytes();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }
}

