package com.biz.crm.business.common.log.local.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 连接参数
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.13 16:37
 */
@Configuration
@Data
public class ExternalLogConfig {

    /**
     * 应用名称
     */
    @Value("${spring.application.name:}")
    private String applicationName;
    /**
     * 定时任务是否清理日志
     */
    @Value("${crm-business-log.open-clean:false}")
    private boolean openClean;

    /**
     * 定时任务清理日志时间
     */
    @Value("${external-log.clean-cron:0 0 6 * * ?}")
    private String cleanCron;

    /**
     * 日志保留天数
     */
    @Value("${external-log.save-day:45}")
    private Integer saveDay;

    /**
     * 日志最小保有量
     */
    @Value("${external-log.min-num:10000}")
    private Long minNum;

}
