/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsRepository;
import com.biz.crm.business.common.log.local.service.ExternalLogService;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogListDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExternalLogServiceImpl
implements ExternalLogService {
    private static final Logger log = LoggerFactory.getLogger(ExternalLogServiceImpl.class);
    @Autowired(required=false)
    private ElasticsearchRestTemplate esTemplate;
    @Autowired(required=false)
    private ExternalLogEsRepository externalLogEsRepository;
    private static final int MAX_TOTAL = 10000;

    @Override
    public void saveEsLog(ExternalLogEsDocument entity) {
        if (ObjectUtils.isEmpty((Object)entity)) {
            return;
        }
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.externalLogEsRepository.save(entity);
    }

    @Override
    public Page<ExternalLogEsDocument> findByConditions(Pageable pageable, ExternalLogListDto reqVo) {
        String dateStr;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        reqVo = Optional.ofNullable(reqVo).orElse(new ExternalLogListDto());
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        if (pageNumber > 0) {
            --pageNumber;
        }
        Assert.isTrue(((pageNumber + 1) * pageSize < 10000 ? 1 : 0) != 0, (String)"\u5206\u9875\u67e5\u8be2,\u5355\u6b21\u67e5\u8be2\u603b\u6570\u4e0d\u53ef\u8d85\u8fc7[10000]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!");
        PageRequest pageEs = PageRequest.of((int)pageNumber, (int)pageable.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)reqVo.getId()).field("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTenantCode())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)reqVo.getTenantCode()).field("tenantCode"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getMethod())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"method", (String)this.getLikeString(reqVo.getMethod())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getRequestUri())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"requestUri", (String)this.getLikeString(reqVo.getRequestUri())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getMethodMsg())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"methodMsg", (String)this.getLikeString(reqVo.getMethodMsg())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getAccessId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"accessId", (String)this.getLikeString(reqVo.getAccessId())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getAccessKey())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"accessKey", (String)this.getLikeString(reqVo.getAccessKey())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getUserName())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"userName", (String)this.getLikeString(reqVo.getUserName())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getFullName())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fullName", (String)this.getLikeString(reqVo.getFullName())));
        }
        if (reqVo.getInvokeType() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"invokeType", (Object)reqVo.getInvokeType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getSourceMain())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"sourceMain", (String)this.getLikeString(reqVo.getSourceMain())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTargetMain())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"targetMain", (String)this.getLikeString(reqVo.getTargetMain())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getStatus())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)reqVo.getStatus()).field("status"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTipMsg())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"tipMsg", (String)this.getLikeString(reqVo.getTipMsg())));
        }
        if (reqVo.getRespJsonSize() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"respJsonSize", (Object)reqVo.getRespJsonSize()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getExceptionStack())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"exceptionStack", (String)this.getLikeString(reqVo.getExceptionStack())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getToken())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"token", (String)this.getLikeString(reqVo.getToken())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getBusinessKey())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"businessKey", (String)this.getLikeString(reqVo.getBusinessKey())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getBusinessType())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"businessType", (String)this.getLikeString(reqVo.getBusinessType())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getReqDateStart())) {
            dateStr = reqVo.getReqDateStart();
            if ("yyyy-MM-dd".length() == dateStr.length()) {
                dateStr = dateStr + " " + " 00:00:00";
            }
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"reqDate").gte((Object)dateStr));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getReqDateEnd())) {
            dateStr = reqVo.getReqDateEnd();
            if ("yyyy-MM-dd".length() == dateStr.length()) {
                dateStr = dateStr + " " + " 23:59:59";
            }
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"reqDate").lte((Object)dateStr));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getRespDateStart())) {
            dateStr = reqVo.getRespDateStart();
            if ("yyyy-MM-dd".length() == dateStr.length()) {
                dateStr = dateStr + " " + " 00:00:00";
            }
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"respDate").gte((Object)dateStr));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getRespDateEnd())) {
            dateStr = reqVo.getRespDateEnd();
            if ("yyyy-MM-dd".length() == dateStr.length()) {
                dateStr = dateStr + " " + " 23:59:59";
            }
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"respDate").lte((Object)dateStr));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getReqDate())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"reqDate", (String)(reqVo.getReqDate() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getRespDate())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"respDate", (String)(reqVo.getRespDate() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getReqHead())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"reqHead", (String)this.getLikeString(reqVo.getReqHead())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getReqJson())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"reqJson", (String)this.getLikeString(reqVo.getReqJson())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getRespJson())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"respJson", (String)this.getLikeString(reqVo.getRespJson())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTipMsg())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"tipMsg", (String)this.getLikeString(reqVo.getTipMsg())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getExceptionStack())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"exceptionStack", (String)this.getLikeString(reqVo.getExceptionStack())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getQueryKey())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)reqVo.getQueryKey(), (String[])new String[]{"reqHead", "reqJson", "respJson", "tipMsg", "exceptionStack"}));
        }
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withPageable((Pageable)pageEs).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"reqDate").order(SortOrder.DESC)}).build();
        SearchHits searchHits = this.esTemplate.search((Query)nativeSearchQuery, ExternalLogEsDocument.class);
        Page resultPage = new Page();
        resultPage.setSize((long)pageable.getPageSize());
        resultPage.setCurrent((long)pageable.getPageNumber());
        resultPage.setTotal(searchHits.getTotalHits() < 10000L ? searchHits.getTotalHits() : 10000L);
        boolean hasContent = reqVo.isHasContent();
        if (searchHits.hasSearchHits()) {
            ArrayList listVos = new ArrayList();
            searchHits.forEach(item -> {
                ExternalLogEsDocument document = (ExternalLogEsDocument)item.getContent();
                if (!hasContent) {
                    document.setReqHead(null);
                    document.setReqJson(null);
                    document.setRespJson(null);
                }
                listVos.add(document);
            });
            resultPage.setRecords(listVos);
        } else {
            resultPage.setCurrent(0L);
        }
        return resultPage;
    }

    private String getLikeString(String queryString) {
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return "";
        }
        return "*" + queryString + "*";
    }

    @Override
    public ExternalLogEsDocument findDetailById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.externalLogEsRepository.findById(id).orElse(null);
    }

    @Override
    public List<ExternalLogDetailDto> findByIdList(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        Iterable documents = this.externalLogEsRepository.findAllById(idList);
        ArrayList documentList = Lists.newArrayList((Iterable)documents);
        if (CollectionUtils.isEmpty((Collection)documentList)) {
            return Lists.newArrayList();
        }
        String json = JSONArray.toJSONString((Object)documentList);
        return JSONArray.parseArray((String)json, ExternalLogDetailDto.class);
    }
}

