/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.log.local.repository.ExternalLogEsDocument;
import com.biz.crm.business.common.log.local.service.ExternalLogService;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.service.ExternalLogVoService;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalLogVoServiceImpl
implements ExternalLogVoService {
    private static final Logger log = LoggerFactory.getLogger(ExternalLogVoServiceImpl.class);
    @Autowired(required=false)
    private ExternalLogService businessLogService;

    public void addOrUpdateLog(ExternalLogDetailDto detailDto, boolean isAdd) {
        try {
            if (isAdd) {
                this.buildAddBaseFields(detailDto);
            } else {
                this.buildUpdateBaseFields(detailDto);
                String json = JSONObject.toJSONString((Object)detailDto);
                ExternalLogEsDocument externalLogEsDocument = (ExternalLogEsDocument)JSONObject.parseObject((String)json, ExternalLogEsDocument.class);
                this.businessLogService.saveEsLog(externalLogEsDocument);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void buildAddBaseFields(ExternalLogDetailDto detailDto) {
        if (Objects.isNull(detailDto.getReqDate())) {
            detailDto.setReqDate(new Date());
        }
    }

    private void buildUpdateBaseFields(ExternalLogDetailDto detailDto) {
        this.buildAddBaseFields(detailDto);
        if (Objects.isNull(detailDto.getRespDate())) {
            detailDto.setRespDate(new Date());
        }
        if (Objects.nonNull(detailDto.getReqDate()) && Objects.nonNull(detailDto.getRespDate())) {
            detailDto.setExecuteTime(Long.valueOf(detailDto.getRespDate().getTime() - detailDto.getReqDate().getTime()));
        }
    }

    public List<ExternalLogDetailDto> findByIdList(List<String> idList) {
        return this.businessLogService.findByIdList(idList);
    }
}

