package com.biz.crm.business.common.log.sdk.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.base.util.IpUtils;
import com.biz.crm.business.common.base.util.UuidCrmUtil;
import com.biz.crm.business.common.log.sdk.constant.ExternalLogGlobalConstants;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.utils.HttpServletRequestUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @describe 构建日志信息
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.29 18:52
 */
@Slf4j
public class ExternalLogUtil {

    /**
     * 构建日志基础信息
     *
     * @param object
     * @return
     */
    public static ExternalLogDetailDto buildLogSaveInfo(Object object) {
        ExternalLogDetailDto reqVo = new ExternalLogDetailDto();
        try {
            HttpServletRequest request = HttpServletRequestUtil.getRequest();
            reqVo.setSourceMain(IpUtils.findRequestIp(request));
            reqVo.setTargetMain(getTargetMain(request));
            reqVo.setReqDate(new Date());
            reqVo.setStatus(ExternalLogGlobalConstants.E);
            reqVo.setInvokeType(ExternalLogGlobalConstants.INTERNAL_INTERFACE);
            String id = StringUtils.isNotEmpty(reqVo.getId()) ? reqVo.getId() : UuidCrmUtil.general();
            reqVo.setId(id);
            if (Objects.isNull(object)) {
                return reqVo;
            }
            if (object instanceof String) {
                reqVo.setReqJson((String) object);
            } else {
                BeanUtils.copyProperties(reqVo, reqVo);
                reqVo.setReqJson(JSON.toJSONString(reqVo));
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return reqVo;
    }

    /**
     * 构建日志基础信息
     *
     * @param object
     * @return
     */
    public static ExternalLogDetailDto buildLogSaveInfo(Object object, UrlAddressVo urlAddressVo) {
        ExternalLogDetailDto reqVo = buildLogSaveInfo(object);
        if (Objects.nonNull(urlAddressVo)) {
            reqVo.setTargetMain(urlAddressVo.getUrl());
            reqVo.setUserName(urlAddressVo.getUserName());
            reqVo.setFullName(urlAddressVo.getFullName());
            reqVo.setAccessId(urlAddressVo.getAccessId());
            reqVo.setAccessKey(urlAddressVo.getAccessKey());
        }
        return reqVo;
    }

    /**
     * 构建日志返回信息
     *
     * @param respVo
     * @param object
     */
    public static void buildLogResult(ExternalLogDetailDto respVo, Object object) {
        if (respVo == null) {
            return;
        }
        respVo.setRespDate(new Date());
        if (Objects.isNull(object)) {
            respVo.setRespJson("返回结果为空!");
            respVo.setStatus(ExternalLogGlobalConstants.E);
            respVo.setRespJsonSize(0);
            return;
        }
        respVo.setStatus(ExternalLogGlobalConstants.S);
        try {
            respVo.setRespJsonSize(1);
            if (object instanceof String) {
                respVo.setRespJson((String) object);
                return;
            }
            respVo.setRespJson(JSON.toJSONString(object));
            if (object instanceof Result) {
                Result result = (Result) object;
                respVo.setStatus(result.isSuccess() ? ExternalLogGlobalConstants.S : ExternalLogGlobalConstants.E);
                respVo.setTipMsg(result.getMessage());
                Object resultResult = result.getResult();
                if (resultResult != null && resultResult.getClass() != null) {
                    if (resultResult instanceof Page) {
                        Page page = (Page) resultResult;
                        respVo.setRespJsonSize(CollectionUtils.isEmpty(page.getRecords()) ? 0 : page.getRecords().size());
                    } else if (resultResult.getClass().isArray()
                            || resultResult instanceof Collection) {
                        List<?> list = (List<?>) resultResult;
                        respVo.setRespJsonSize(list.size());
                    }
                }
            } else if (object.getClass().isArray() || object instanceof Collection) {
                List<?> list = (List<?>) object;
                respVo.setRespJsonSize(list.size());
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 获取目标源
     *
     * @param request
     * @return
     */
    private static String getTargetMain(HttpServletRequest request) {
        if (request == null) {
            return "0.0.0.0";
        }
        StringBuffer requestUrl = request.getRequestURL();
        if (requestUrl == null
                || StringUtils.isEmpty(requestUrl.toString())) {
            return "0.0.0.0";
        }
        String result = requestUrl.toString();
        String requestUri = request.getRequestURI();
        if (StringUtils.isNotBlank(requestUri)) {
            result = result.replace(requestUri, "");
        }
        return result;
    }
}
