/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.log.sdk.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.base.util.IpUtils;
import com.biz.crm.business.common.base.util.UuidCrmUtil;
import com.biz.crm.business.common.log.sdk.constant.ExternalLogGlobalConstants;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.utils.HttpServletRequestUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class ExternalLogUtil {
    private static final Logger log = LoggerFactory.getLogger(ExternalLogUtil.class);

    public static ExternalLogDetailDto buildLogSaveInfo(Object object) {
        ExternalLogDetailDto reqVo = new ExternalLogDetailDto();
        try {
            HttpServletRequest request = HttpServletRequestUtil.getRequest();
            reqVo.setSourceMain(IpUtils.findRequestIp((HttpServletRequest)request));
            reqVo.setTargetMain(ExternalLogUtil.getTargetMain(request));
            reqVo.setReqDate(new Date());
            reqVo.setStatus("E");
            reqVo.setInvokeType(ExternalLogGlobalConstants.INTERNAL_INTERFACE);
            String id = StringUtils.isNotEmpty((CharSequence)reqVo.getId()) ? reqVo.getId() : UuidCrmUtil.general();
            reqVo.setId(id);
            if (Objects.isNull(object)) {
                return reqVo;
            }
            if (object instanceof String) {
                reqVo.setReqJson((String)object);
            } else {
                BeanUtils.copyProperties((Object)reqVo, (Object)reqVo);
                reqVo.setReqJson(JSON.toJSONString((Object)reqVo));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return reqVo;
    }

    public static ExternalLogDetailDto buildLogSaveInfo(Object object, UrlAddressVo urlAddressVo) {
        ExternalLogDetailDto reqVo = ExternalLogUtil.buildLogSaveInfo(object);
        if (Objects.nonNull(urlAddressVo)) {
            reqVo.setTargetMain(urlAddressVo.getUrl());
            reqVo.setUserName(urlAddressVo.getUserName());
            reqVo.setFullName(urlAddressVo.getFullName());
            reqVo.setAccessId(urlAddressVo.getAccessId());
            reqVo.setAccessKey(urlAddressVo.getAccessKey());
        }
        return reqVo;
    }

    public static void buildLogResult(ExternalLogDetailDto respVo, Object object) {
        if (respVo == null) {
            return;
        }
        respVo.setRespDate(new Date());
        if (Objects.isNull(object)) {
            respVo.setRespJson("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
            respVo.setStatus("E");
            respVo.setRespJsonSize(0);
            return;
        }
        respVo.setStatus("S");
        try {
            respVo.setRespJsonSize(1);
            if (object instanceof String) {
                respVo.setRespJson((String)object);
                return;
            }
            respVo.setRespJson(JSON.toJSONString((Object)object));
            if (object instanceof Result) {
                Result result = (Result)object;
                respVo.setStatus(result.isSuccess() ? "S" : "E");
                respVo.setTipMsg(result.getMessage());
                Object resultResult = result.getResult();
                if (resultResult != null && resultResult.getClass() != null) {
                    if (resultResult instanceof Page) {
                        Page page = (Page)resultResult;
                        respVo.setRespJsonSize(CollectionUtils.isEmpty((Collection)page.getRecords()) ? 0 : page.getRecords().size());
                    } else if (resultResult.getClass().isArray() || resultResult instanceof Collection) {
                        List list = (List)resultResult;
                        respVo.setRespJsonSize(list.size());
                    }
                }
            } else if (object.getClass().isArray() || object instanceof Collection) {
                List list = (List)object;
                respVo.setRespJsonSize(list.size());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String getTargetMain(HttpServletRequest request) {
        if (request == null) {
            return "0.0.0.0";
        }
        StringBuffer requestUrl = request.getRequestURL();
        if (requestUrl == null || StringUtils.isEmpty((CharSequence)requestUrl.toString())) {
            return "0.0.0.0";
        }
        String result = requestUrl.toString();
        String requestUri = request.getRequestURI();
        if (StringUtils.isNotBlank((CharSequence)requestUri)) {
            result = result.replace(requestUri, "");
        }
        return result;
    }
}

