package com.biz.crm.business.common.log.sdk.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 接口日志
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2021/8/4 19:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExternalLogDetailDto implements Serializable {

    private static final long serialVersionUID = -2064839291276801057L;

    private String id;

    @ApiModelProperty("请求方法")
    private String method;

    @ApiModelProperty("接口地址")
    private String requestUri;

    @ApiModelProperty("请求方法描述")
    private String methodMsg;

    @ApiModelProperty(name = "账号ID")
    private String accessId;

    @ApiModelProperty("请求账号ak")
    private String accessKey;

    @ApiModelProperty("请求账号")
    private String userName;

    @ApiModelProperty("请求账户名称")
    private String fullName;

    @ApiModelProperty("网关内部的某个顶级租户编号")
    private String tenantCode;

    @ApiModelProperty("调用类型：1、内部系统调用外部接口；2、外部系统调用内部系统接口；其他值无效")
    private Integer invokeType = 1;

    @ApiModelProperty("请求源")
    private String sourceMain;

    @ApiModelProperty("目标源")
    private String targetMain;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("消息文本")
    private String tipMsg;

    @ApiModelProperty("请求时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reqDate;

    @ApiModelProperty("请求head信息")
    private String reqHead;

    @ApiModelProperty("请求数据")
    private String reqJson;

    @ApiModelProperty("返回数据")
    private String respJson;

    @ApiModelProperty("返回数据条数")
    private Integer respJsonSize;

    @ApiModelProperty("返回时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date respDate;

    @ApiModelProperty("执行时间")
    private Long executeTime = 0L;

    @ApiModelProperty("异常信息")
    private String exceptionStack;

    @ApiModelProperty("当前请求token")
    private String token;

    @ApiModelProperty("业务标记")
    private String businessKey;

    @ApiModelProperty("业务类型")
    private String businessType;
}
