/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.page.cache.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.base.service.RedisLockService;
import com.biz.crm.business.common.page.cache.service.BusinessPageCacheHelper;
import com.biz.crm.business.common.page.cache.service.BusinessPageCacheService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BusinessPageCacheController<Vo, Dto> {
    private static final Logger log = LoggerFactory.getLogger(BusinessPageCacheController.class);
    @Autowired(required=false)
    protected BusinessPageCacheService<Vo, Dto> businessPageCacheService;
    @Autowired(required=false)
    protected BusinessPageCacheHelper<Vo, Dto> helper;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u83b7\u53d6\u660e\u7ec6\u5217\u8868\u7f13\u5b58\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findCachePageList"})
    public Result<Page<Vo>> findCachePageList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") Dto dto) {
        String pageCacheLockKey = this.helper.getRedisPageCacheLockKey(cacheKey);
        try {
            Boolean lockFlag = this.redisLockService.tryLock(pageCacheLockKey, TimeUnit.MINUTES, 3600L);
            Validate.isTrue((boolean)lockFlag, (String)"\u5206\u9875\u6570\u636e\u6b63\u5728\u52a0\u8f7d,\u8bf7\u4e0d\u8981\u91cd\u590d\u70b9\u51fb", (Object[])new Object[0]);
            Page<Vo> page = this.businessPageCacheService.findCachePageList(pageable, dto, cacheKey);
            Result result = Result.ok(page);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisLockService.unlock(pageCacheLockKey);
        }
    }

    @ApiOperation(value="\u65b0\u589e\u4e00\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u63d2\u5165\u4e00\u6761\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"addItemCache"})
    public Result<Page<Vo>> addItemCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") Dto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<Dto> itemList) {
        try {
            this.businessPageCacheService.addItemCache(cacheKey, itemList);
            Page<Vo> page = this.businessPageCacheService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u590d\u5236\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u590d\u5236\u9009\u4e2d\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"copyItemListCache"})
    public Result<Page<Vo>> copyItemListCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") Dto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u590d\u5236\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<Dto> itemList) {
        try {
            this.businessPageCacheService.copyItemListCache(cacheKey, itemList);
            Page<Vo> page = this.businessPageCacheService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u5230\u7f13\u5b58\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"saveCurrentPageCache"})
    public Result<Page<Vo>> saveCurrentPageCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") Dto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<Dto> saveList) {
        try {
            this.businessPageCacheService.saveCurrentPageCache(cacheKey, saveList);
            Page<Vo> page = this.businessPageCacheService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u591a\u884c\u5220\u9664\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"deleteCacheList"})
    public Result<Page<Vo>> deleteCacheList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") Dto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u5220\u9664\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<Dto> itemList) {
        try {
            this.businessPageCacheService.deleteCacheList(cacheKey, itemList);
            Page<Vo> page = this.businessPageCacheService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6e05\u7406\u7f13\u5b58\u63a5\u53e3")
    @PostMapping(value={"clearCache"})
    public Result clearCache(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            this.businessPageCacheService.clearCache(cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    public void checkPageCacheLock(String cacheKey) {
        String pageCacheLockKey = this.helper.getRedisPageCacheLockKey(cacheKey);
        Boolean lockFlag = this.redisLockService.isLock(pageCacheLockKey);
        Validate.isTrue((lockFlag == false ? 1 : 0) != 0, (String)"\u660e\u7ec6\u6570\u636e\u6b63\u5728\u52a0\u8f7d,\u8bf7\u7b49\u5f85\u52a0\u8f7d\u5b8c\u6210", (Object[])new Object[0]);
    }
}

