/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.page.cache.service.internal;

import com.biz.crm.business.common.base.util.DateUtil;
import com.biz.crm.business.common.base.util.UuidCrmUtil;
import com.biz.crm.business.common.page.cache.repository.BusinessImportCacheEsDocument;
import com.biz.crm.business.common.page.cache.repository.BusinessImportCacheEsRepository;
import com.biz.crm.business.common.page.cache.service.BusinessImportCacheService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class BusinessImportCacheServiceImpl
implements BusinessImportCacheService {
    @Autowired(required=false)
    private BusinessImportCacheEsRepository repository;
    @Autowired(required=false)
    private ElasticsearchRestTemplate esTemplate;

    @Override
    public void saveImportCache(String businessKey, String cacheKey, String dataListJson) {
        if (StringUtils.isEmpty((CharSequence)dataListJson)) {
            return;
        }
        BusinessImportCacheEsDocument entity = new BusinessImportCacheEsDocument();
        entity.setId(UuidCrmUtil.general());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setReqDate(DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        entity.setBusinessKey(businessKey);
        entity.setCacheKey(cacheKey);
        entity.setDataListJson(dataListJson);
        this.repository.save(entity);
    }

    @Override
    public void updateImportCache(String businessKey, String cacheKey, String dataListJson) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return;
        }
        BusinessImportCacheEsDocument cacheEsDocument = this.getByCacheKey(businessKey, cacheKey);
        cacheEsDocument.setDataListJson(dataListJson);
        this.repository.save(cacheEsDocument);
    }

    @Override
    public void saveOrUpdateImportCache(String businessKey, String cacheKey, String dataListJson) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return;
        }
        BusinessImportCacheEsDocument cacheEsDocument = this.getByCacheKey(businessKey, cacheKey);
        if (null == cacheEsDocument) {
            this.saveImportCache(businessKey, cacheKey, dataListJson);
            return;
        }
        cacheEsDocument.setDataListJson(dataListJson);
        this.repository.save(cacheEsDocument);
    }

    @Override
    public String getDataListJson(String cacheKey) {
        return this.getDataListJson(null, cacheKey);
    }

    @Override
    public String getDataListJson(String businessKey, String cacheKey) {
        BusinessImportCacheEsDocument cacheEsDocument = this.getByCacheKey(businessKey, cacheKey);
        if (null != cacheEsDocument) {
            return cacheEsDocument.getDataListJson();
        }
        return null;
    }

    @Override
    public BusinessImportCacheEsDocument getByCacheKey(String businessKey, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return null;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)businessKey).field("businessKey"));
        }
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)cacheKey).field("cacheKey"));
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)TenantUtils.getTenantCode()).field("tenantCode"));
        NativeSearchQuery query = new NativeSearchQuery((QueryBuilder)queryBuilder);
        SearchHits search = this.esTemplate.search((Query)query, BusinessImportCacheEsDocument.class);
        if (search.hasSearchHits()) {
            return (BusinessImportCacheEsDocument)search.getSearchHit(0).getContent();
        }
        return null;
    }
}

