/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.page.cache.task;

import com.biz.crm.business.common.base.service.RedisLockService;
import com.biz.crm.business.common.base.util.DateUtil;
import com.biz.crm.business.common.page.cache.repository.BusinessImportCacheEsDocument;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class DeleteBusinessImportCacheCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DeleteBusinessImportCacheCornTask.class);
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Resource
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    private static final String APPLICATION_NAME = "crm-tpm";

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::deleteData, triggerContext -> {
            CronTrigger trigger = new CronTrigger("0 0 6 * * ?");
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    private void deleteData() {
        boolean lock;
        if (!APPLICATION_NAME.equalsIgnoreCase(this.applicationName)) {
            return;
        }
        String lockKey = "business_import_cache:lock:del";
        if (this.redisLockService != null && !(lock = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L))) {
            return;
        }
        try {
            Calendar instance = Calendar.getInstance();
            instance.add(5, -1);
            String cleanDate = DateUtil.getDateStrByFormat((Date)instance.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"reqDate").lte((Object)cleanDate));
            NativeSearchQuery deleteQuery = new NativeSearchQuery((QueryBuilder)boolQueryBuilder);
            ByQueryResponse queryResponse = this.elasticsearchRestTemplate.delete((Query)deleteQuery, BusinessImportCacheEsDocument.class);
            log.info("\u5bfc\u5165\u7f13\u5b58ES\u65e5\u5fd7\u6e05\u7406[{}]\u53ca\u5176\u4ee5\u524d\u7684 \u6e05\u7406\u6570\u91cf:[{}]\u6761", (Object)cleanDate, (Object)queryResponse.getDeleted());
        }
        catch (Exception e) {
            log.error("=====>    \u5bfc\u5165\u7f13\u5b58ES\u65e5\u5fd7\u6e05\u7406 \u5f02\u5e38   <=====");
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.redisLockService != null) {
            this.redisLockService.unlock(lockKey);
        }
    }
}

